/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.BoundingBoxCopier;
import software.amazon.awssdk.services.location.model.CountryCodeListCopier;
import software.amazon.awssdk.services.location.model.FilterPlaceCategoryListCopier;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchPlaceIndexForTextRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, SearchPlaceIndexForTextRequest> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(SearchPlaceIndexForTextRequest.getter(SearchPlaceIndexForTextRequest::indexName)).setter(SearchPlaceIndexForTextRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("IndexName").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(SearchPlaceIndexForTextRequest.getter(SearchPlaceIndexForTextRequest::text)).setter(SearchPlaceIndexForTextRequest.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<List<Double>> BIAS_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BiasPosition").getter(SearchPlaceIndexForTextRequest.getter(SearchPlaceIndexForTextRequest::biasPosition)).setter(SearchPlaceIndexForTextRequest.setter(Builder::biasPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BiasPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> FILTER_B_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterBBox").getter(SearchPlaceIndexForTextRequest.getter(SearchPlaceIndexForTextRequest::filterBBox)).setter(SearchPlaceIndexForTextRequest.setter(Builder::filterBBox)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterBBox").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FILTER_COUNTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterCountries").getter(SearchPlaceIndexForTextRequest.getter(SearchPlaceIndexForTextRequest::filterCountries)).setter(SearchPlaceIndexForTextRequest.setter(Builder::filterCountries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCountries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchPlaceIndexForTextRequest.getter(SearchPlaceIndexForTextRequest::maxResults)).setter(SearchPlaceIndexForTextRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(SearchPlaceIndexForTextRequest.getter(SearchPlaceIndexForTextRequest::language)).setter(SearchPlaceIndexForTextRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final SdkField<List<String>> FILTER_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterCategories").getter(SearchPlaceIndexForTextRequest.getter(SearchPlaceIndexForTextRequest::filterCategories)).setter(SearchPlaceIndexForTextRequest.setter(Builder::filterCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(SearchPlaceIndexForTextRequest.getter(SearchPlaceIndexForTextRequest::key)).setter(SearchPlaceIndexForTextRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD, TEXT_FIELD, BIAS_POSITION_FIELD, FILTER_B_BOX_FIELD, FILTER_COUNTRIES_FIELD, MAX_RESULTS_FIELD, LANGUAGE_FIELD, FILTER_CATEGORIES_FIELD, KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchPlaceIndexForTextRequest.memberNameToFieldInitializer();
    private final String indexName;
    private final String text;
    private final List<Double> biasPosition;
    private final List<Double> filterBBox;
    private final List<String> filterCountries;
    private final Integer maxResults;
    private final String language;
    private final List<String> filterCategories;
    private final String key;

    private SearchPlaceIndexForTextRequest(BuilderImpl builder) {
        super(builder);
        this.indexName = builder.indexName;
        this.text = builder.text;
        this.biasPosition = builder.biasPosition;
        this.filterBBox = builder.filterBBox;
        this.filterCountries = builder.filterCountries;
        this.maxResults = builder.maxResults;
        this.language = builder.language;
        this.filterCategories = builder.filterCategories;
        this.key = builder.key;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String text() {
        return this.text;
    }

    public final boolean hasBiasPosition() {
        return this.biasPosition != null && !(this.biasPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> biasPosition() {
        return this.biasPosition;
    }

    public final boolean hasFilterBBox() {
        return this.filterBBox != null && !(this.filterBBox instanceof SdkAutoConstructList);
    }

    public final List<Double> filterBBox() {
        return this.filterBBox;
    }

    public final boolean hasFilterCountries() {
        return this.filterCountries != null && !(this.filterCountries instanceof SdkAutoConstructList);
    }

    public final List<String> filterCountries() {
        return this.filterCountries;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String language() {
        return this.language;
    }

    public final boolean hasFilterCategories() {
        return this.filterCategories != null && !(this.filterCategories instanceof SdkAutoConstructList);
    }

    public final List<String> filterCategories() {
        return this.filterCategories;
    }

    public final String key() {
        return this.key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBiasPosition() ? this.biasPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterBBox() ? this.filterBBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterCountries() ? this.filterCountries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterCategories() ? this.filterCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForTextRequest)) {
            return false;
        }
        SearchPlaceIndexForTextRequest other = (SearchPlaceIndexForTextRequest)((Object)obj);
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.text(), other.text()) && this.hasBiasPosition() == other.hasBiasPosition() && Objects.equals(this.biasPosition(), other.biasPosition()) && this.hasFilterBBox() == other.hasFilterBBox() && Objects.equals(this.filterBBox(), other.filterBBox()) && this.hasFilterCountries() == other.hasFilterCountries() && Objects.equals(this.filterCountries(), other.filterCountries()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.language(), other.language()) && this.hasFilterCategories() == other.hasFilterCategories() && Objects.equals(this.filterCategories(), other.filterCategories()) && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"SearchPlaceIndexForTextRequest").add("IndexName", (Object)this.indexName()).add("Text", (Object)(this.text() == null ? null : "*** Sensitive Data Redacted ***")).add("BiasPosition", (Object)(this.biasPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("FilterBBox", (Object)(this.filterBBox() == null ? null : "*** Sensitive Data Redacted ***")).add("FilterCountries", (Object)(this.filterCountries() == null ? null : "*** Sensitive Data Redacted ***")).add("MaxResults", (Object)this.maxResults()).add("Language", (Object)this.language()).add("FilterCategories", this.hasFilterCategories() ? this.filterCategories() : null).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "BiasPosition": {
                return Optional.ofNullable(clazz.cast(this.biasPosition()));
            }
            case "FilterBBox": {
                return Optional.ofNullable(clazz.cast(this.filterBBox()));
            }
            case "FilterCountries": {
                return Optional.ofNullable(clazz.cast(this.filterCountries()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "FilterCategories": {
                return Optional.ofNullable(clazz.cast(this.filterCategories()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IndexName", INDEX_NAME_FIELD);
        map.put("Text", TEXT_FIELD);
        map.put("BiasPosition", BIAS_POSITION_FIELD);
        map.put("FilterBBox", FILTER_B_BOX_FIELD);
        map.put("FilterCountries", FILTER_COUNTRIES_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        map.put("FilterCategories", FILTER_CATEGORIES_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForTextRequest, T> g) {
        return obj -> g.apply((SearchPlaceIndexForTextRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String indexName;
        private String text;
        private List<Double> biasPosition = DefaultSdkAutoConstructList.getInstance();
        private List<Double> filterBBox = DefaultSdkAutoConstructList.getInstance();
        private List<String> filterCountries = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String language;
        private List<String> filterCategories = DefaultSdkAutoConstructList.getInstance();
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForTextRequest model) {
            super(model);
            this.indexName(model.indexName);
            this.text(model.text);
            this.biasPosition(model.biasPosition);
            this.filterBBox(model.filterBBox);
            this.filterCountries(model.filterCountries);
            this.maxResults(model.maxResults);
            this.language(model.language);
            this.filterCategories(model.filterCategories);
            this.key(model.key);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final Collection<Double> getBiasPosition() {
            if (this.biasPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.biasPosition;
        }

        public final void setBiasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
        }

        @Override
        public final Builder biasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder biasPosition(Double ... biasPosition) {
            this.biasPosition(Arrays.asList(biasPosition));
            return this;
        }

        public final Collection<Double> getFilterBBox() {
            if (this.filterBBox instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterBBox;
        }

        public final void setFilterBBox(Collection<Double> filterBBox) {
            this.filterBBox = BoundingBoxCopier.copy(filterBBox);
        }

        @Override
        public final Builder filterBBox(Collection<Double> filterBBox) {
            this.filterBBox = BoundingBoxCopier.copy(filterBBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterBBox(Double ... filterBBox) {
            this.filterBBox(Arrays.asList(filterBBox));
            return this;
        }

        public final Collection<String> getFilterCountries() {
            if (this.filterCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterCountries;
        }

        public final void setFilterCountries(Collection<String> filterCountries) {
            this.filterCountries = CountryCodeListCopier.copy(filterCountries);
        }

        @Override
        public final Builder filterCountries(Collection<String> filterCountries) {
            this.filterCountries = CountryCodeListCopier.copy(filterCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterCountries(String ... filterCountries) {
            this.filterCountries(Arrays.asList(filterCountries));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final Collection<String> getFilterCategories() {
            if (this.filterCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterCategories;
        }

        public final void setFilterCategories(Collection<String> filterCategories) {
            this.filterCategories = FilterPlaceCategoryListCopier.copy(filterCategories);
        }

        @Override
        public final Builder filterCategories(Collection<String> filterCategories) {
            this.filterCategories = FilterPlaceCategoryListCopier.copy(filterCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterCategories(String ... filterCategories) {
            this.filterCategories(Arrays.asList(filterCategories));
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchPlaceIndexForTextRequest build() {
            return new SearchPlaceIndexForTextRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchPlaceIndexForTextRequest> {
        public Builder indexName(String var1);

        public Builder text(String var1);

        public Builder biasPosition(Collection<Double> var1);

        public Builder biasPosition(Double ... var1);

        public Builder filterBBox(Collection<Double> var1);

        public Builder filterBBox(Double ... var1);

        public Builder filterCountries(Collection<String> var1);

        public Builder filterCountries(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder language(String var1);

        public Builder filterCategories(Collection<String> var1);

        public Builder filterCategories(String ... var1);

        public Builder key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

