/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.LegGeometry;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.services.location.model.Step;
import software.amazon.awssdk.services.location.model.StepListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Leg
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Leg> {
    private static final SdkField<List<Double>> START_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StartPosition").getter(Leg.getter(Leg::startPosition)).setter(Leg.setter(Builder::startPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> END_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndPosition").getter(Leg.getter(Leg::endPosition)).setter(Leg.setter(Builder::endPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Distance").getter(Leg.getter(Leg::distance)).setter(Leg.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<Double> DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DurationSeconds").getter(Leg.getter(Leg::durationSeconds)).setter(Leg.setter(Builder::durationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()}).build();
    private static final SdkField<LegGeometry> GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Geometry").getter(Leg.getter(Leg::geometry)).setter(Leg.setter(Builder::geometry)).constructor(LegGeometry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()}).build();
    private static final SdkField<List<Step>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Steps").getter(Leg.getter(Leg::steps)).setter(Leg.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Step::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_POSITION_FIELD, END_POSITION_FIELD, DISTANCE_FIELD, DURATION_SECONDS_FIELD, GEOMETRY_FIELD, STEPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Leg.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Double> startPosition;
    private final List<Double> endPosition;
    private final Double distance;
    private final Double durationSeconds;
    private final LegGeometry geometry;
    private final List<Step> steps;

    private Leg(BuilderImpl builder) {
        this.startPosition = builder.startPosition;
        this.endPosition = builder.endPosition;
        this.distance = builder.distance;
        this.durationSeconds = builder.durationSeconds;
        this.geometry = builder.geometry;
        this.steps = builder.steps;
    }

    public final boolean hasStartPosition() {
        return this.startPosition != null && !(this.startPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> startPosition() {
        return this.startPosition;
    }

    public final boolean hasEndPosition() {
        return this.endPosition != null && !(this.endPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> endPosition() {
        return this.endPosition;
    }

    public final Double distance() {
        return this.distance;
    }

    public final Double durationSeconds() {
        return this.durationSeconds;
    }

    public final LegGeometry geometry() {
        return this.geometry;
    }

    public final boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public final List<Step> steps() {
        return this.steps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStartPosition() ? this.startPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndPosition() ? this.endPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometry());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSteps() ? this.steps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Leg)) {
            return false;
        }
        Leg other = (Leg)obj;
        return this.hasStartPosition() == other.hasStartPosition() && Objects.equals(this.startPosition(), other.startPosition()) && this.hasEndPosition() == other.hasEndPosition() && Objects.equals(this.endPosition(), other.endPosition()) && Objects.equals(this.distance(), other.distance()) && Objects.equals(this.durationSeconds(), other.durationSeconds()) && Objects.equals(this.geometry(), other.geometry()) && this.hasSteps() == other.hasSteps() && Objects.equals(this.steps(), other.steps());
    }

    public final String toString() {
        return ToString.builder((String)"Leg").add("StartPosition", (Object)(this.startPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("EndPosition", (Object)(this.endPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("Distance", (Object)this.distance()).add("DurationSeconds", (Object)this.durationSeconds()).add("Geometry", (Object)this.geometry()).add("Steps", this.hasSteps() ? this.steps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartPosition": {
                return Optional.ofNullable(clazz.cast(this.startPosition()));
            }
            case "EndPosition": {
                return Optional.ofNullable(clazz.cast(this.endPosition()));
            }
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "DurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
            case "Geometry": {
                return Optional.ofNullable(clazz.cast(this.geometry()));
            }
            case "Steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StartPosition", START_POSITION_FIELD);
        map.put("EndPosition", END_POSITION_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("DurationSeconds", DURATION_SECONDS_FIELD);
        map.put("Geometry", GEOMETRY_FIELD);
        map.put("Steps", STEPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Leg, T> g) {
        return obj -> g.apply((Leg)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Double> startPosition = DefaultSdkAutoConstructList.getInstance();
        private List<Double> endPosition = DefaultSdkAutoConstructList.getInstance();
        private Double distance;
        private Double durationSeconds;
        private LegGeometry geometry;
        private List<Step> steps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Leg model) {
            this.startPosition(model.startPosition);
            this.endPosition(model.endPosition);
            this.distance(model.distance);
            this.durationSeconds(model.durationSeconds);
            this.geometry(model.geometry);
            this.steps(model.steps);
        }

        public final Collection<Double> getStartPosition() {
            if (this.startPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.startPosition;
        }

        public final void setStartPosition(Collection<Double> startPosition) {
            this.startPosition = PositionCopier.copy(startPosition);
        }

        @Override
        public final Builder startPosition(Collection<Double> startPosition) {
            this.startPosition = PositionCopier.copy(startPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startPosition(Double ... startPosition) {
            this.startPosition(Arrays.asList(startPosition));
            return this;
        }

        public final Collection<Double> getEndPosition() {
            if (this.endPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endPosition;
        }

        public final void setEndPosition(Collection<Double> endPosition) {
            this.endPosition = PositionCopier.copy(endPosition);
        }

        @Override
        public final Builder endPosition(Collection<Double> endPosition) {
            this.endPosition = PositionCopier.copy(endPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endPosition(Double ... endPosition) {
            this.endPosition(Arrays.asList(endPosition));
            return this;
        }

        public final Double getDistance() {
            return this.distance;
        }

        public final void setDistance(Double distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Double distance) {
            this.distance = distance;
            return this;
        }

        public final Double getDurationSeconds() {
            return this.durationSeconds;
        }

        public final void setDurationSeconds(Double durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Double durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final LegGeometry.Builder getGeometry() {
            return this.geometry != null ? this.geometry.toBuilder() : null;
        }

        public final void setGeometry(LegGeometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(LegGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final List<Step.Builder> getSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<Step.BuilderImpl> steps) {
            this.steps = StepListCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<Step> steps) {
            this.steps = StepListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Step ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<Step.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (Step)((Step.Builder)Step.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Leg build() {
            return new Leg(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Leg> {
        public Builder startPosition(Collection<Double> var1);

        public Builder startPosition(Double ... var1);

        public Builder endPosition(Collection<Double> var1);

        public Builder endPosition(Double ... var1);

        public Builder distance(Double var1);

        public Builder durationSeconds(Double var1);

        public Builder geometry(LegGeometry var1);

        default public Builder geometry(Consumer<LegGeometry.Builder> geometry) {
            return this.geometry((LegGeometry)((LegGeometry.Builder)LegGeometry.builder().applyMutation(geometry)).build());
        }

        public Builder steps(Collection<Step> var1);

        public Builder steps(Step ... var1);

        public Builder steps(Consumer<Step.Builder> ... var1);
    }
}

