/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.CustomLayerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MapConfigurationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MapConfigurationUpdate> {
    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoliticalView").getter(MapConfigurationUpdate.getter(MapConfigurationUpdate::politicalView)).setter(MapConfigurationUpdate.setter(Builder::politicalView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliticalView").build()}).build();
    private static final SdkField<List<String>> CUSTOM_LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomLayers").getter(MapConfigurationUpdate.getter(MapConfigurationUpdate::customLayers)).setter(MapConfigurationUpdate.setter(Builder::customLayers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLayers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLITICAL_VIEW_FIELD, CUSTOM_LAYERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MapConfigurationUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String politicalView;
    private final List<String> customLayers;

    private MapConfigurationUpdate(BuilderImpl builder) {
        this.politicalView = builder.politicalView;
        this.customLayers = builder.customLayers;
    }

    public final String politicalView() {
        return this.politicalView;
    }

    public final boolean hasCustomLayers() {
        return this.customLayers != null && !(this.customLayers instanceof SdkAutoConstructList);
    }

    public final List<String> customLayers() {
        return this.customLayers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomLayers() ? this.customLayers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapConfigurationUpdate)) {
            return false;
        }
        MapConfigurationUpdate other = (MapConfigurationUpdate)obj;
        return Objects.equals(this.politicalView(), other.politicalView()) && this.hasCustomLayers() == other.hasCustomLayers() && Objects.equals(this.customLayers(), other.customLayers());
    }

    public final String toString() {
        return ToString.builder((String)"MapConfigurationUpdate").add("PoliticalView", (Object)this.politicalView()).add("CustomLayers", this.hasCustomLayers() ? this.customLayers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoliticalView": {
                return Optional.ofNullable(clazz.cast(this.politicalView()));
            }
            case "CustomLayers": {
                return Optional.ofNullable(clazz.cast(this.customLayers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PoliticalView", POLITICAL_VIEW_FIELD);
        map.put("CustomLayers", CUSTOM_LAYERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MapConfigurationUpdate, T> g) {
        return obj -> g.apply((MapConfigurationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String politicalView;
        private List<String> customLayers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MapConfigurationUpdate model) {
            this.politicalView(model.politicalView);
            this.customLayers(model.customLayers);
        }

        public final String getPoliticalView() {
            return this.politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final Collection<String> getCustomLayers() {
            if (this.customLayers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customLayers;
        }

        public final void setCustomLayers(Collection<String> customLayers) {
            this.customLayers = CustomLayerListCopier.copy(customLayers);
        }

        @Override
        public final Builder customLayers(Collection<String> customLayers) {
            this.customLayers = CustomLayerListCopier.copy(customLayers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customLayers(String ... customLayers) {
            this.customLayers(Arrays.asList(customLayers));
            return this;
        }

        public MapConfigurationUpdate build() {
            return new MapConfigurationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MapConfigurationUpdate> {
        public Builder politicalView(String var1);

        public Builder customLayers(Collection<String> var1);

        public Builder customLayers(String ... var1);
    }
}

