/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.CellSignals;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.services.location.model.PositionalAccuracy;
import software.amazon.awssdk.services.location.model.WiFiAccessPoint;
import software.amazon.awssdk.services.location.model.WiFiAccessPointListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceState> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(DeviceState.getter(DeviceState::deviceId)).setter(DeviceState.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<Instant> SAMPLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SampleTime").getter(DeviceState.getter(DeviceState::sampleTime)).setter(DeviceState.setter(Builder::sampleTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(DeviceState.getter(DeviceState::position)).setter(DeviceState.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PositionalAccuracy> ACCURACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Accuracy").getter(DeviceState.getter(DeviceState::accuracy)).setter(DeviceState.setter(Builder::accuracy)).constructor(PositionalAccuracy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accuracy").build()}).build();
    private static final SdkField<String> IPV4_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv4Address").getter(DeviceState.getter(DeviceState::ipv4Address)).setter(DeviceState.setter(Builder::ipv4Address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Address").build()}).build();
    private static final SdkField<List<WiFiAccessPoint>> WI_FI_ACCESS_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WiFiAccessPoints").getter(DeviceState.getter(DeviceState::wiFiAccessPoints)).setter(DeviceState.setter(Builder::wiFiAccessPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WiFiAccessPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WiFiAccessPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CellSignals> CELL_SIGNALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CellSignals").getter(DeviceState.getter(DeviceState::cellSignals)).setter(DeviceState.setter(Builder::cellSignals)).constructor(CellSignals::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellSignals").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, SAMPLE_TIME_FIELD, POSITION_FIELD, ACCURACY_FIELD, IPV4_ADDRESS_FIELD, WI_FI_ACCESS_POINTS_FIELD, CELL_SIGNALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeviceState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String deviceId;
    private final Instant sampleTime;
    private final List<Double> position;
    private final PositionalAccuracy accuracy;
    private final String ipv4Address;
    private final List<WiFiAccessPoint> wiFiAccessPoints;
    private final CellSignals cellSignals;

    private DeviceState(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.sampleTime = builder.sampleTime;
        this.position = builder.position;
        this.accuracy = builder.accuracy;
        this.ipv4Address = builder.ipv4Address;
        this.wiFiAccessPoints = builder.wiFiAccessPoints;
        this.cellSignals = builder.cellSignals;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final Instant sampleTime() {
        return this.sampleTime;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public final PositionalAccuracy accuracy() {
        return this.accuracy;
    }

    public final String ipv4Address() {
        return this.ipv4Address;
    }

    public final boolean hasWiFiAccessPoints() {
        return this.wiFiAccessPoints != null && !(this.wiFiAccessPoints instanceof SdkAutoConstructList);
    }

    public final List<WiFiAccessPoint> wiFiAccessPoints() {
        return this.wiFiAccessPoints;
    }

    public final CellSignals cellSignals() {
        return this.cellSignals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accuracy());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4Address());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWiFiAccessPoints() ? this.wiFiAccessPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cellSignals());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceState)) {
            return false;
        }
        DeviceState other = (DeviceState)obj;
        return Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.sampleTime(), other.sampleTime()) && this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && Objects.equals(this.accuracy(), other.accuracy()) && Objects.equals(this.ipv4Address(), other.ipv4Address()) && this.hasWiFiAccessPoints() == other.hasWiFiAccessPoints() && Objects.equals(this.wiFiAccessPoints(), other.wiFiAccessPoints()) && Objects.equals(this.cellSignals(), other.cellSignals());
    }

    public final String toString() {
        return ToString.builder((String)"DeviceState").add("DeviceId", (Object)this.deviceId()).add("SampleTime", (Object)this.sampleTime()).add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).add("Accuracy", (Object)this.accuracy()).add("Ipv4Address", (Object)this.ipv4Address()).add("WiFiAccessPoints", this.hasWiFiAccessPoints() ? this.wiFiAccessPoints() : null).add("CellSignals", (Object)this.cellSignals()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "SampleTime": {
                return Optional.ofNullable(clazz.cast(this.sampleTime()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "Accuracy": {
                return Optional.ofNullable(clazz.cast(this.accuracy()));
            }
            case "Ipv4Address": {
                return Optional.ofNullable(clazz.cast(this.ipv4Address()));
            }
            case "WiFiAccessPoints": {
                return Optional.ofNullable(clazz.cast(this.wiFiAccessPoints()));
            }
            case "CellSignals": {
                return Optional.ofNullable(clazz.cast(this.cellSignals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeviceId", DEVICE_ID_FIELD);
        map.put("SampleTime", SAMPLE_TIME_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("Accuracy", ACCURACY_FIELD);
        map.put("Ipv4Address", IPV4_ADDRESS_FIELD);
        map.put("WiFiAccessPoints", WI_FI_ACCESS_POINTS_FIELD);
        map.put("CellSignals", CELL_SIGNALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceState, T> g) {
        return obj -> g.apply((DeviceState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceId;
        private Instant sampleTime;
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();
        private PositionalAccuracy accuracy;
        private String ipv4Address;
        private List<WiFiAccessPoint> wiFiAccessPoints = DefaultSdkAutoConstructList.getInstance();
        private CellSignals cellSignals;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceState model) {
            this.deviceId(model.deviceId);
            this.sampleTime(model.sampleTime);
            this.position(model.position);
            this.accuracy(model.accuracy);
            this.ipv4Address(model.ipv4Address);
            this.wiFiAccessPoints(model.wiFiAccessPoints);
            this.cellSignals(model.cellSignals);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final Instant getSampleTime() {
            return this.sampleTime;
        }

        public final void setSampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
        }

        @Override
        public final Builder sampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final PositionalAccuracy.Builder getAccuracy() {
            return this.accuracy != null ? this.accuracy.toBuilder() : null;
        }

        public final void setAccuracy(PositionalAccuracy.BuilderImpl accuracy) {
            this.accuracy = accuracy != null ? accuracy.build() : null;
        }

        @Override
        public final Builder accuracy(PositionalAccuracy accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public final String getIpv4Address() {
            return this.ipv4Address;
        }

        public final void setIpv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
        }

        @Override
        public final Builder ipv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
            return this;
        }

        public final List<WiFiAccessPoint.Builder> getWiFiAccessPoints() {
            List<WiFiAccessPoint.Builder> result = WiFiAccessPointListCopier.copyToBuilder(this.wiFiAccessPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWiFiAccessPoints(Collection<WiFiAccessPoint.BuilderImpl> wiFiAccessPoints) {
            this.wiFiAccessPoints = WiFiAccessPointListCopier.copyFromBuilder(wiFiAccessPoints);
        }

        @Override
        public final Builder wiFiAccessPoints(Collection<WiFiAccessPoint> wiFiAccessPoints) {
            this.wiFiAccessPoints = WiFiAccessPointListCopier.copy(wiFiAccessPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wiFiAccessPoints(WiFiAccessPoint ... wiFiAccessPoints) {
            this.wiFiAccessPoints(Arrays.asList(wiFiAccessPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wiFiAccessPoints(Consumer<WiFiAccessPoint.Builder> ... wiFiAccessPoints) {
            this.wiFiAccessPoints(Stream.of(wiFiAccessPoints).map(c -> (WiFiAccessPoint)((WiFiAccessPoint.Builder)WiFiAccessPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CellSignals.Builder getCellSignals() {
            return this.cellSignals != null ? this.cellSignals.toBuilder() : null;
        }

        public final void setCellSignals(CellSignals.BuilderImpl cellSignals) {
            this.cellSignals = cellSignals != null ? cellSignals.build() : null;
        }

        @Override
        public final Builder cellSignals(CellSignals cellSignals) {
            this.cellSignals = cellSignals;
            return this;
        }

        public DeviceState build() {
            return new DeviceState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceState> {
        public Builder deviceId(String var1);

        public Builder sampleTime(Instant var1);

        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);

        public Builder accuracy(PositionalAccuracy var1);

        default public Builder accuracy(Consumer<PositionalAccuracy.Builder> accuracy) {
            return this.accuracy((PositionalAccuracy)((PositionalAccuracy.Builder)PositionalAccuracy.builder().applyMutation(accuracy)).build());
        }

        public Builder ipv4Address(String var1);

        public Builder wiFiAccessPoints(Collection<WiFiAccessPoint> var1);

        public Builder wiFiAccessPoints(WiFiAccessPoint ... var1);

        public Builder wiFiAccessPoints(Consumer<WiFiAccessPoint.Builder> ... var1);

        public Builder cellSignals(CellSignals var1);

        default public Builder cellSignals(Consumer<CellSignals.Builder> cellSignals) {
            return this.cellSignals((CellSignals)((CellSignals.Builder)CellSignals.builder().applyMutation(cellSignals)).build());
        }
    }
}

