/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.location.model.ApiKeyRestrictions;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.services.location.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeKeyResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, DescribeKeyResponse> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(DescribeKeyResponse.getter(DescribeKeyResponse::key)).setter(DescribeKeyResponse.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyArn").getter(DescribeKeyResponse.getter(DescribeKeyResponse::keyArn)).setter(DescribeKeyResponse.setter(Builder::keyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyArn").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(DescribeKeyResponse.getter(DescribeKeyResponse::keyName)).setter(DescribeKeyResponse.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()}).build();
    private static final SdkField<ApiKeyRestrictions> RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Restrictions").getter(DescribeKeyResponse.getter(DescribeKeyResponse::restrictions)).setter(DescribeKeyResponse.setter(Builder::restrictions)).constructor(ApiKeyRestrictions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Restrictions").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(DescribeKeyResponse.getter(DescribeKeyResponse::createTime)).setter(DescribeKeyResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> EXPIRE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpireTime").getter(DescribeKeyResponse.getter(DescribeKeyResponse::expireTime)).setter(DescribeKeyResponse.setter(Builder::expireTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpireTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(DescribeKeyResponse.getter(DescribeKeyResponse::updateTime)).setter(DescribeKeyResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeKeyResponse.getter(DescribeKeyResponse::description)).setter(DescribeKeyResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeKeyResponse.getter(DescribeKeyResponse::tags)).setter(DescribeKeyResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, KEY_ARN_FIELD, KEY_NAME_FIELD, RESTRICTIONS_FIELD, CREATE_TIME_FIELD, EXPIRE_TIME_FIELD, UPDATE_TIME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeKeyResponse.memberNameToFieldInitializer();
    private final String key;
    private final String keyArn;
    private final String keyName;
    private final ApiKeyRestrictions restrictions;
    private final Instant createTime;
    private final Instant expireTime;
    private final Instant updateTime;
    private final String description;
    private final Map<String, String> tags;

    private DescribeKeyResponse(BuilderImpl builder) {
        super(builder);
        this.key = builder.key;
        this.keyArn = builder.keyArn;
        this.keyName = builder.keyName;
        this.restrictions = builder.restrictions;
        this.createTime = builder.createTime;
        this.expireTime = builder.expireTime;
        this.updateTime = builder.updateTime;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String key() {
        return this.key;
    }

    public final String keyArn() {
        return this.keyArn;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final ApiKeyRestrictions restrictions() {
        return this.restrictions;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant expireTime() {
        return this.expireTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictions());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.expireTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyResponse)) {
            return false;
        }
        DescribeKeyResponse other = (DescribeKeyResponse)((Object)obj);
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.keyArn(), other.keyArn()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.restrictions(), other.restrictions()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.expireTime(), other.expireTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeKeyResponse").add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).add("KeyArn", (Object)this.keyArn()).add("KeyName", (Object)this.keyName()).add("Restrictions", (Object)this.restrictions()).add("CreateTime", (Object)this.createTime()).add("ExpireTime", (Object)this.expireTime()).add("UpdateTime", (Object)this.updateTime()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "KeyArn": {
                return Optional.ofNullable(clazz.cast(this.keyArn()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "Restrictions": {
                return Optional.ofNullable(clazz.cast(this.restrictions()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "ExpireTime": {
                return Optional.ofNullable(clazz.cast(this.expireTime()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Key", KEY_FIELD);
        map.put("KeyArn", KEY_ARN_FIELD);
        map.put("KeyName", KEY_NAME_FIELD);
        map.put("Restrictions", RESTRICTIONS_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("ExpireTime", EXPIRE_TIME_FIELD);
        map.put("UpdateTime", UPDATE_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeKeyResponse, T> g) {
        return obj -> g.apply((DescribeKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private String key;
        private String keyArn;
        private String keyName;
        private ApiKeyRestrictions restrictions;
        private Instant createTime;
        private Instant expireTime;
        private Instant updateTime;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyResponse model) {
            super(model);
            this.key(model.key);
            this.keyArn(model.keyArn);
            this.keyName(model.keyName);
            this.restrictions(model.restrictions);
            this.createTime(model.createTime);
            this.expireTime(model.expireTime);
            this.updateTime(model.updateTime);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getKeyArn() {
            return this.keyArn;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final ApiKeyRestrictions.Builder getRestrictions() {
            return this.restrictions != null ? this.restrictions.toBuilder() : null;
        }

        public final void setRestrictions(ApiKeyRestrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        @Override
        public final Builder restrictions(ApiKeyRestrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getExpireTime() {
            return this.expireTime;
        }

        public final void setExpireTime(Instant expireTime) {
            this.expireTime = expireTime;
        }

        @Override
        public final Builder expireTime(Instant expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeKeyResponse build() {
            return new DescribeKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeKeyResponse> {
        public Builder key(String var1);

        public Builder keyArn(String var1);

        public Builder keyName(String var1);

        public Builder restrictions(ApiKeyRestrictions var1);

        default public Builder restrictions(Consumer<ApiKeyRestrictions.Builder> restrictions) {
            return this.restrictions((ApiKeyRestrictions)((ApiKeyRestrictions.Builder)ApiKeyRestrictions.builder().applyMutation(restrictions)).build());
        }

        public Builder createTime(Instant var1);

        public Builder expireTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

