/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.DimensionUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TruckDimensions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TruckDimensions> {
    private static final SdkField<Double> LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Length").getter(TruckDimensions.getter(TruckDimensions::length)).setter(TruckDimensions.setter(Builder::length)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Length").build()}).build();
    private static final SdkField<Double> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Height").getter(TruckDimensions.getter(TruckDimensions::height)).setter(TruckDimensions.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()}).build();
    private static final SdkField<Double> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Width").getter(TruckDimensions.getter(TruckDimensions::width)).setter(TruckDimensions.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(TruckDimensions.getter(TruckDimensions::unitAsString)).setter(TruckDimensions.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENGTH_FIELD, HEIGHT_FIELD, WIDTH_FIELD, UNIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TruckDimensions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double length;
    private final Double height;
    private final Double width;
    private final String unit;

    private TruckDimensions(BuilderImpl builder) {
        this.length = builder.length;
        this.height = builder.height;
        this.width = builder.width;
        this.unit = builder.unit;
    }

    public final Double length() {
        return this.length;
    }

    public final Double height() {
        return this.height;
    }

    public final Double width() {
        return this.width;
    }

    public final DimensionUnit unit() {
        return DimensionUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.length());
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TruckDimensions)) {
            return false;
        }
        TruckDimensions other = (TruckDimensions)obj;
        return Objects.equals(this.length(), other.length()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.width(), other.width()) && Objects.equals(this.unitAsString(), other.unitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TruckDimensions").add("Length", (Object)this.length()).add("Height", (Object)this.height()).add("Width", (Object)this.width()).add("Unit", (Object)this.unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Length": {
                return Optional.ofNullable(clazz.cast(this.length()));
            }
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Length", LENGTH_FIELD);
        map.put("Height", HEIGHT_FIELD);
        map.put("Width", WIDTH_FIELD);
        map.put("Unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TruckDimensions, T> g) {
        return obj -> g.apply((TruckDimensions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double length;
        private Double height;
        private Double width;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(TruckDimensions model) {
            this.length(model.length);
            this.height(model.height);
            this.width(model.width);
            this.unit(model.unit);
        }

        public final Double getLength() {
            return this.length;
        }

        public final void setLength(Double length) {
            this.length = length;
        }

        @Override
        public final Builder length(Double length) {
            this.length = length;
            return this;
        }

        public final Double getHeight() {
            return this.height;
        }

        public final void setHeight(Double height) {
            this.height = height;
        }

        @Override
        public final Builder height(Double height) {
            this.height = height;
            return this;
        }

        public final Double getWidth() {
            return this.width;
        }

        public final void setWidth(Double width) {
            this.width = width;
        }

        @Override
        public final Builder width(Double width) {
            this.width = width;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(DimensionUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public TruckDimensions build() {
            return new TruckDimensions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TruckDimensions> {
        public Builder length(Double var1);

        public Builder height(Double var1);

        public Builder width(Double var1);

        public Builder unit(String var1);

        public Builder unit(DimensionUnit var1);
    }
}

