/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.services.location.model.PositionPropertyMapCopier;
import software.amazon.awssdk.services.location.model.PositionalAccuracy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDevicePositionResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, GetDevicePositionResponse> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(GetDevicePositionResponse.getter(GetDevicePositionResponse::deviceId)).setter(GetDevicePositionResponse.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<Instant> SAMPLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SampleTime").getter(GetDevicePositionResponse.getter(GetDevicePositionResponse::sampleTime)).setter(GetDevicePositionResponse.setter(Builder::sampleTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> RECEIVED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReceivedTime").getter(GetDevicePositionResponse.getter(GetDevicePositionResponse::receivedTime)).setter(GetDevicePositionResponse.setter(Builder::receivedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(GetDevicePositionResponse.getter(GetDevicePositionResponse::position)).setter(GetDevicePositionResponse.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PositionalAccuracy> ACCURACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Accuracy").getter(GetDevicePositionResponse.getter(GetDevicePositionResponse::accuracy)).setter(GetDevicePositionResponse.setter(Builder::accuracy)).constructor(PositionalAccuracy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accuracy").build()}).build();
    private static final SdkField<Map<String, String>> POSITION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PositionProperties").getter(GetDevicePositionResponse.getter(GetDevicePositionResponse::positionProperties)).setter(GetDevicePositionResponse.setter(Builder::positionProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositionProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, SAMPLE_TIME_FIELD, RECEIVED_TIME_FIELD, POSITION_FIELD, ACCURACY_FIELD, POSITION_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDevicePositionResponse.memberNameToFieldInitializer();
    private final String deviceId;
    private final Instant sampleTime;
    private final Instant receivedTime;
    private final List<Double> position;
    private final PositionalAccuracy accuracy;
    private final Map<String, String> positionProperties;

    private GetDevicePositionResponse(BuilderImpl builder) {
        super(builder);
        this.deviceId = builder.deviceId;
        this.sampleTime = builder.sampleTime;
        this.receivedTime = builder.receivedTime;
        this.position = builder.position;
        this.accuracy = builder.accuracy;
        this.positionProperties = builder.positionProperties;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final Instant sampleTime() {
        return this.sampleTime;
    }

    public final Instant receivedTime() {
        return this.receivedTime;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public final PositionalAccuracy accuracy() {
        return this.accuracy;
    }

    public final boolean hasPositionProperties() {
        return this.positionProperties != null && !(this.positionProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> positionProperties() {
        return this.positionProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.receivedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accuracy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPositionProperties() ? this.positionProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePositionResponse)) {
            return false;
        }
        GetDevicePositionResponse other = (GetDevicePositionResponse)((Object)obj);
        return Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.sampleTime(), other.sampleTime()) && Objects.equals(this.receivedTime(), other.receivedTime()) && this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && Objects.equals(this.accuracy(), other.accuracy()) && this.hasPositionProperties() == other.hasPositionProperties() && Objects.equals(this.positionProperties(), other.positionProperties());
    }

    public final String toString() {
        return ToString.builder((String)"GetDevicePositionResponse").add("DeviceId", (Object)this.deviceId()).add("SampleTime", (Object)this.sampleTime()).add("ReceivedTime", (Object)this.receivedTime()).add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).add("Accuracy", (Object)this.accuracy()).add("PositionProperties", (Object)(this.positionProperties() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "SampleTime": {
                return Optional.ofNullable(clazz.cast(this.sampleTime()));
            }
            case "ReceivedTime": {
                return Optional.ofNullable(clazz.cast(this.receivedTime()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "Accuracy": {
                return Optional.ofNullable(clazz.cast(this.accuracy()));
            }
            case "PositionProperties": {
                return Optional.ofNullable(clazz.cast(this.positionProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeviceId", DEVICE_ID_FIELD);
        map.put("SampleTime", SAMPLE_TIME_FIELD);
        map.put("ReceivedTime", RECEIVED_TIME_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("Accuracy", ACCURACY_FIELD);
        map.put("PositionProperties", POSITION_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDevicePositionResponse, T> g) {
        return obj -> g.apply((GetDevicePositionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private String deviceId;
        private Instant sampleTime;
        private Instant receivedTime;
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();
        private PositionalAccuracy accuracy;
        private Map<String, String> positionProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePositionResponse model) {
            super(model);
            this.deviceId(model.deviceId);
            this.sampleTime(model.sampleTime);
            this.receivedTime(model.receivedTime);
            this.position(model.position);
            this.accuracy(model.accuracy);
            this.positionProperties(model.positionProperties);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final Instant getSampleTime() {
            return this.sampleTime;
        }

        public final void setSampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
        }

        @Override
        public final Builder sampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
            return this;
        }

        public final Instant getReceivedTime() {
            return this.receivedTime;
        }

        public final void setReceivedTime(Instant receivedTime) {
            this.receivedTime = receivedTime;
        }

        @Override
        public final Builder receivedTime(Instant receivedTime) {
            this.receivedTime = receivedTime;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final PositionalAccuracy.Builder getAccuracy() {
            return this.accuracy != null ? this.accuracy.toBuilder() : null;
        }

        public final void setAccuracy(PositionalAccuracy.BuilderImpl accuracy) {
            this.accuracy = accuracy != null ? accuracy.build() : null;
        }

        @Override
        public final Builder accuracy(PositionalAccuracy accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public final Map<String, String> getPositionProperties() {
            if (this.positionProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.positionProperties;
        }

        public final void setPositionProperties(Map<String, String> positionProperties) {
            this.positionProperties = PositionPropertyMapCopier.copy(positionProperties);
        }

        @Override
        public final Builder positionProperties(Map<String, String> positionProperties) {
            this.positionProperties = PositionPropertyMapCopier.copy(positionProperties);
            return this;
        }

        @Override
        public GetDevicePositionResponse build() {
            return new GetDevicePositionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDevicePositionResponse> {
        public Builder deviceId(String var1);

        public Builder sampleTime(Instant var1);

        public Builder receivedTime(Instant var1);

        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);

        public Builder accuracy(PositionalAccuracy var1);

        default public Builder accuracy(Consumer<PositionalAccuracy.Builder> accuracy) {
            return this.accuracy((PositionalAccuracy)((PositionalAccuracy.Builder)PositionalAccuracy.builder().applyMutation(accuracy)).build());
        }

        public Builder positionProperties(Map<String, String> var1);
    }
}

