/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMapSpritesRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, GetMapSpritesRequest> {
    private static final SdkField<String> MAP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MapName").getter(GetMapSpritesRequest.getter(GetMapSpritesRequest::mapName)).setter(GetMapSpritesRequest.setter(Builder::mapName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("MapName").build()}).build();
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileName").getter(GetMapSpritesRequest.getter(GetMapSpritesRequest::fileName)).setter(GetMapSpritesRequest.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FileName").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(GetMapSpritesRequest.getter(GetMapSpritesRequest::key)).setter(GetMapSpritesRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_NAME_FIELD, FILE_NAME_FIELD, KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMapSpritesRequest.memberNameToFieldInitializer();
    private final String mapName;
    private final String fileName;
    private final String key;

    private GetMapSpritesRequest(BuilderImpl builder) {
        super(builder);
        this.mapName = builder.mapName;
        this.fileName = builder.fileName;
        this.key = builder.key;
    }

    public final String mapName() {
        return this.mapName;
    }

    public final String fileName() {
        return this.fileName;
    }

    public final String key() {
        return this.key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mapName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMapSpritesRequest)) {
            return false;
        }
        GetMapSpritesRequest other = (GetMapSpritesRequest)((Object)obj);
        return Objects.equals(this.mapName(), other.mapName()) && Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"GetMapSpritesRequest").add("MapName", (Object)this.mapName()).add("FileName", (Object)this.fileName()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MapName": {
                return Optional.ofNullable(clazz.cast(this.mapName()));
            }
            case "FileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MapName", MAP_NAME_FIELD);
        map.put("FileName", FILE_NAME_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMapSpritesRequest, T> g) {
        return obj -> g.apply((GetMapSpritesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String mapName;
        private String fileName;
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMapSpritesRequest model) {
            super(model);
            this.mapName(model.mapName);
            this.fileName(model.fileName);
            this.key(model.key);
        }

        public final String getMapName() {
            return this.mapName;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMapSpritesRequest build() {
            return new GetMapSpritesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMapSpritesRequest> {
        public Builder mapName(String var1);

        public Builder fileName(String var1);

        public Builder key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

