/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.ApiKeyRestrictions;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateKeyRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, UpdateKeyRequest> {
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(UpdateKeyRequest.getter(UpdateKeyRequest::keyName)).setter(UpdateKeyRequest.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("KeyName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateKeyRequest.getter(UpdateKeyRequest::description)).setter(UpdateKeyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> EXPIRE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpireTime").getter(UpdateKeyRequest.getter(UpdateKeyRequest::expireTime)).setter(UpdateKeyRequest.setter(Builder::expireTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpireTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> NO_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NoExpiry").getter(UpdateKeyRequest.getter(UpdateKeyRequest::noExpiry)).setter(UpdateKeyRequest.setter(Builder::noExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoExpiry").build()}).build();
    private static final SdkField<Boolean> FORCE_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceUpdate").getter(UpdateKeyRequest.getter(UpdateKeyRequest::forceUpdate)).setter(UpdateKeyRequest.setter(Builder::forceUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceUpdate").build()}).build();
    private static final SdkField<ApiKeyRestrictions> RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Restrictions").getter(UpdateKeyRequest.getter(UpdateKeyRequest::restrictions)).setter(UpdateKeyRequest.setter(Builder::restrictions)).constructor(ApiKeyRestrictions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Restrictions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_NAME_FIELD, DESCRIPTION_FIELD, EXPIRE_TIME_FIELD, NO_EXPIRY_FIELD, FORCE_UPDATE_FIELD, RESTRICTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateKeyRequest.memberNameToFieldInitializer();
    private final String keyName;
    private final String description;
    private final Instant expireTime;
    private final Boolean noExpiry;
    private final Boolean forceUpdate;
    private final ApiKeyRestrictions restrictions;

    private UpdateKeyRequest(BuilderImpl builder) {
        super(builder);
        this.keyName = builder.keyName;
        this.description = builder.description;
        this.expireTime = builder.expireTime;
        this.noExpiry = builder.noExpiry;
        this.forceUpdate = builder.forceUpdate;
        this.restrictions = builder.restrictions;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final String description() {
        return this.description;
    }

    public final Instant expireTime() {
        return this.expireTime;
    }

    public final Boolean noExpiry() {
        return this.noExpiry;
    }

    public final Boolean forceUpdate() {
        return this.forceUpdate;
    }

    public final ApiKeyRestrictions restrictions() {
        return this.restrictions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.expireTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.noExpiry());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKeyRequest)) {
            return false;
        }
        UpdateKeyRequest other = (UpdateKeyRequest)((Object)obj);
        return Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.expireTime(), other.expireTime()) && Objects.equals(this.noExpiry(), other.noExpiry()) && Objects.equals(this.forceUpdate(), other.forceUpdate()) && Objects.equals(this.restrictions(), other.restrictions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateKeyRequest").add("KeyName", (Object)this.keyName()).add("Description", (Object)this.description()).add("ExpireTime", (Object)this.expireTime()).add("NoExpiry", (Object)this.noExpiry()).add("ForceUpdate", (Object)this.forceUpdate()).add("Restrictions", (Object)this.restrictions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ExpireTime": {
                return Optional.ofNullable(clazz.cast(this.expireTime()));
            }
            case "NoExpiry": {
                return Optional.ofNullable(clazz.cast(this.noExpiry()));
            }
            case "ForceUpdate": {
                return Optional.ofNullable(clazz.cast(this.forceUpdate()));
            }
            case "Restrictions": {
                return Optional.ofNullable(clazz.cast(this.restrictions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyName", KEY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ExpireTime", EXPIRE_TIME_FIELD);
        map.put("NoExpiry", NO_EXPIRY_FIELD);
        map.put("ForceUpdate", FORCE_UPDATE_FIELD);
        map.put("Restrictions", RESTRICTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKeyRequest, T> g) {
        return obj -> g.apply((UpdateKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String keyName;
        private String description;
        private Instant expireTime;
        private Boolean noExpiry;
        private Boolean forceUpdate;
        private ApiKeyRestrictions restrictions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKeyRequest model) {
            super(model);
            this.keyName(model.keyName);
            this.description(model.description);
            this.expireTime(model.expireTime);
            this.noExpiry(model.noExpiry);
            this.forceUpdate(model.forceUpdate);
            this.restrictions(model.restrictions);
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getExpireTime() {
            return this.expireTime;
        }

        public final void setExpireTime(Instant expireTime) {
            this.expireTime = expireTime;
        }

        @Override
        public final Builder expireTime(Instant expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public final Boolean getNoExpiry() {
            return this.noExpiry;
        }

        public final void setNoExpiry(Boolean noExpiry) {
            this.noExpiry = noExpiry;
        }

        @Override
        public final Builder noExpiry(Boolean noExpiry) {
            this.noExpiry = noExpiry;
            return this;
        }

        public final Boolean getForceUpdate() {
            return this.forceUpdate;
        }

        public final void setForceUpdate(Boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
        }

        @Override
        public final Builder forceUpdate(Boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
            return this;
        }

        public final ApiKeyRestrictions.Builder getRestrictions() {
            return this.restrictions != null ? this.restrictions.toBuilder() : null;
        }

        public final void setRestrictions(ApiKeyRestrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        @Override
        public final Builder restrictions(ApiKeyRestrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKeyRequest build() {
            return new UpdateKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateKeyRequest> {
        public Builder keyName(String var1);

        public Builder description(String var1);

        public Builder expireTime(Instant var1);

        public Builder noExpiry(Boolean var1);

        public Builder forceUpdate(Boolean var1);

        public Builder restrictions(ApiKeyRestrictions var1);

        default public Builder restrictions(Consumer<ApiKeyRestrictions.Builder> restrictions) {
            return this.restrictions((ApiKeyRestrictions)((ApiKeyRestrictions.Builder)ApiKeyRestrictions.builder().applyMutation(restrictions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

