/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.BatchItemError;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateDevicePositionError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchUpdateDevicePositionError> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(BatchUpdateDevicePositionError.getter(BatchUpdateDevicePositionError::deviceId)).setter(BatchUpdateDevicePositionError.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<Instant> SAMPLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SampleTime").getter(BatchUpdateDevicePositionError.getter(BatchUpdateDevicePositionError::sampleTime)).setter(BatchUpdateDevicePositionError.setter(Builder::sampleTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<BatchItemError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(BatchUpdateDevicePositionError.getter(BatchUpdateDevicePositionError::error)).setter(BatchUpdateDevicePositionError.setter(Builder::error)).constructor(BatchItemError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, SAMPLE_TIME_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchUpdateDevicePositionError.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String deviceId;
    private final Instant sampleTime;
    private final BatchItemError error;

    private BatchUpdateDevicePositionError(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.sampleTime = builder.sampleTime;
        this.error = builder.error;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final Instant sampleTime() {
        return this.sampleTime;
    }

    public final BatchItemError error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateDevicePositionError)) {
            return false;
        }
        BatchUpdateDevicePositionError other = (BatchUpdateDevicePositionError)obj;
        return Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.sampleTime(), other.sampleTime()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateDevicePositionError").add("DeviceId", (Object)this.deviceId()).add("SampleTime", (Object)this.sampleTime()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "SampleTime": {
                return Optional.ofNullable(clazz.cast(this.sampleTime()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeviceId", DEVICE_ID_FIELD);
        map.put("SampleTime", SAMPLE_TIME_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateDevicePositionError, T> g) {
        return obj -> g.apply((BatchUpdateDevicePositionError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceId;
        private Instant sampleTime;
        private BatchItemError error;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateDevicePositionError model) {
            this.deviceId(model.deviceId);
            this.sampleTime(model.sampleTime);
            this.error(model.error);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final Instant getSampleTime() {
            return this.sampleTime;
        }

        public final void setSampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
        }

        @Override
        public final Builder sampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
            return this;
        }

        public final BatchItemError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(BatchItemError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(BatchItemError error) {
            this.error = error;
            return this;
        }

        public BatchUpdateDevicePositionError build() {
            return new BatchUpdateDevicePositionError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchUpdateDevicePositionError> {
        public Builder deviceId(String var1);

        public Builder sampleTime(Instant var1);

        public Builder error(BatchItemError var1);

        default public Builder error(Consumer<BatchItemError.Builder> error) {
            return this.error((BatchItemError)((BatchItemError.Builder)BatchItemError.builder().applyMutation(error)).build());
        }
    }
}

