/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.services.location.model.PositionalAccuracy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferredState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferredState> {
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(InferredState.getter(InferredState::position)).setter(InferredState.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PositionalAccuracy> ACCURACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Accuracy").getter(InferredState.getter(InferredState::accuracy)).setter(InferredState.setter(Builder::accuracy)).constructor(PositionalAccuracy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accuracy").build()}).build();
    private static final SdkField<Double> DEVIATION_DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DeviationDistance").getter(InferredState.getter(InferredState::deviationDistance)).setter(InferredState.setter(Builder::deviationDistance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviationDistance").build()}).build();
    private static final SdkField<Boolean> PROXY_DETECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ProxyDetected").getter(InferredState.getter(InferredState::proxyDetected)).setter(InferredState.setter(Builder::proxyDetected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyDetected").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITION_FIELD, ACCURACY_FIELD, DEVIATION_DISTANCE_FIELD, PROXY_DETECTED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InferredState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Double> position;
    private final PositionalAccuracy accuracy;
    private final Double deviationDistance;
    private final Boolean proxyDetected;

    private InferredState(BuilderImpl builder) {
        this.position = builder.position;
        this.accuracy = builder.accuracy;
        this.deviationDistance = builder.deviationDistance;
        this.proxyDetected = builder.proxyDetected;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public final PositionalAccuracy accuracy() {
        return this.accuracy;
    }

    public final Double deviationDistance() {
        return this.deviationDistance;
    }

    public final Boolean proxyDetected() {
        return this.proxyDetected;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accuracy());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviationDistance());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyDetected());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferredState)) {
            return false;
        }
        InferredState other = (InferredState)obj;
        return this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && Objects.equals(this.accuracy(), other.accuracy()) && Objects.equals(this.deviationDistance(), other.deviationDistance()) && Objects.equals(this.proxyDetected(), other.proxyDetected());
    }

    public final String toString() {
        return ToString.builder((String)"InferredState").add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).add("Accuracy", (Object)this.accuracy()).add("DeviationDistance", (Object)this.deviationDistance()).add("ProxyDetected", (Object)this.proxyDetected()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "Accuracy": {
                return Optional.ofNullable(clazz.cast(this.accuracy()));
            }
            case "DeviationDistance": {
                return Optional.ofNullable(clazz.cast(this.deviationDistance()));
            }
            case "ProxyDetected": {
                return Optional.ofNullable(clazz.cast(this.proxyDetected()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Position", POSITION_FIELD);
        map.put("Accuracy", ACCURACY_FIELD);
        map.put("DeviationDistance", DEVIATION_DISTANCE_FIELD);
        map.put("ProxyDetected", PROXY_DETECTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferredState, T> g) {
        return obj -> g.apply((InferredState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();
        private PositionalAccuracy accuracy;
        private Double deviationDistance;
        private Boolean proxyDetected;

        private BuilderImpl() {
        }

        private BuilderImpl(InferredState model) {
            this.position(model.position);
            this.accuracy(model.accuracy);
            this.deviationDistance(model.deviationDistance);
            this.proxyDetected(model.proxyDetected);
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final PositionalAccuracy.Builder getAccuracy() {
            return this.accuracy != null ? this.accuracy.toBuilder() : null;
        }

        public final void setAccuracy(PositionalAccuracy.BuilderImpl accuracy) {
            this.accuracy = accuracy != null ? accuracy.build() : null;
        }

        @Override
        public final Builder accuracy(PositionalAccuracy accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public final Double getDeviationDistance() {
            return this.deviationDistance;
        }

        public final void setDeviationDistance(Double deviationDistance) {
            this.deviationDistance = deviationDistance;
        }

        @Override
        public final Builder deviationDistance(Double deviationDistance) {
            this.deviationDistance = deviationDistance;
            return this;
        }

        public final Boolean getProxyDetected() {
            return this.proxyDetected;
        }

        public final void setProxyDetected(Boolean proxyDetected) {
            this.proxyDetected = proxyDetected;
        }

        @Override
        public final Builder proxyDetected(Boolean proxyDetected) {
            this.proxyDetected = proxyDetected;
            return this;
        }

        public InferredState build() {
            return new InferredState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferredState> {
        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);

        public Builder accuracy(PositionalAccuracy var1);

        default public Builder accuracy(Consumer<PositionalAccuracy.Builder> accuracy) {
            return this.accuracy((PositionalAccuracy)((PositionalAccuracy.Builder)PositionalAccuracy.builder().applyMutation(accuracy)).build());
        }

        public Builder deviationDistance(Double var1);

        public Builder proxyDetected(Boolean var1);
    }
}

