/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.DistanceUnit;
import software.amazon.awssdk.services.location.model.InferredState;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyDevicePositionResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, VerifyDevicePositionResponse> {
    private static final SdkField<InferredState> INFERRED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InferredState").getter(VerifyDevicePositionResponse.getter(VerifyDevicePositionResponse::inferredState)).setter(VerifyDevicePositionResponse.setter(Builder::inferredState)).constructor(InferredState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferredState").build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(VerifyDevicePositionResponse.getter(VerifyDevicePositionResponse::deviceId)).setter(VerifyDevicePositionResponse.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<Instant> SAMPLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SampleTime").getter(VerifyDevicePositionResponse.getter(VerifyDevicePositionResponse::sampleTime)).setter(VerifyDevicePositionResponse.setter(Builder::sampleTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> RECEIVED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReceivedTime").getter(VerifyDevicePositionResponse.getter(VerifyDevicePositionResponse::receivedTime)).setter(VerifyDevicePositionResponse.setter(Builder::receivedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistanceUnit").getter(VerifyDevicePositionResponse.getter(VerifyDevicePositionResponse::distanceUnitAsString)).setter(VerifyDevicePositionResponse.setter(Builder::distanceUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERRED_STATE_FIELD, DEVICE_ID_FIELD, SAMPLE_TIME_FIELD, RECEIVED_TIME_FIELD, DISTANCE_UNIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VerifyDevicePositionResponse.memberNameToFieldInitializer();
    private final InferredState inferredState;
    private final String deviceId;
    private final Instant sampleTime;
    private final Instant receivedTime;
    private final String distanceUnit;

    private VerifyDevicePositionResponse(BuilderImpl builder) {
        super(builder);
        this.inferredState = builder.inferredState;
        this.deviceId = builder.deviceId;
        this.sampleTime = builder.sampleTime;
        this.receivedTime = builder.receivedTime;
        this.distanceUnit = builder.distanceUnit;
    }

    public final InferredState inferredState() {
        return this.inferredState;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final Instant sampleTime() {
        return this.sampleTime;
    }

    public final Instant receivedTime() {
        return this.receivedTime;
    }

    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(this.distanceUnit);
    }

    public final String distanceUnitAsString() {
        return this.distanceUnit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inferredState());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.receivedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceUnitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyDevicePositionResponse)) {
            return false;
        }
        VerifyDevicePositionResponse other = (VerifyDevicePositionResponse)((Object)obj);
        return Objects.equals(this.inferredState(), other.inferredState()) && Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.sampleTime(), other.sampleTime()) && Objects.equals(this.receivedTime(), other.receivedTime()) && Objects.equals(this.distanceUnitAsString(), other.distanceUnitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyDevicePositionResponse").add("InferredState", (Object)this.inferredState()).add("DeviceId", (Object)this.deviceId()).add("SampleTime", (Object)this.sampleTime()).add("ReceivedTime", (Object)this.receivedTime()).add("DistanceUnit", (Object)this.distanceUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InferredState": {
                return Optional.ofNullable(clazz.cast(this.inferredState()));
            }
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "SampleTime": {
                return Optional.ofNullable(clazz.cast(this.sampleTime()));
            }
            case "ReceivedTime": {
                return Optional.ofNullable(clazz.cast(this.receivedTime()));
            }
            case "DistanceUnit": {
                return Optional.ofNullable(clazz.cast(this.distanceUnitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InferredState", INFERRED_STATE_FIELD);
        map.put("DeviceId", DEVICE_ID_FIELD);
        map.put("SampleTime", SAMPLE_TIME_FIELD);
        map.put("ReceivedTime", RECEIVED_TIME_FIELD);
        map.put("DistanceUnit", DISTANCE_UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifyDevicePositionResponse, T> g) {
        return obj -> g.apply((VerifyDevicePositionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private InferredState inferredState;
        private String deviceId;
        private Instant sampleTime;
        private Instant receivedTime;
        private String distanceUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyDevicePositionResponse model) {
            super(model);
            this.inferredState(model.inferredState);
            this.deviceId(model.deviceId);
            this.sampleTime(model.sampleTime);
            this.receivedTime(model.receivedTime);
            this.distanceUnit(model.distanceUnit);
        }

        public final InferredState.Builder getInferredState() {
            return this.inferredState != null ? this.inferredState.toBuilder() : null;
        }

        public final void setInferredState(InferredState.BuilderImpl inferredState) {
            this.inferredState = inferredState != null ? inferredState.build() : null;
        }

        @Override
        public final Builder inferredState(InferredState inferredState) {
            this.inferredState = inferredState;
            return this;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final Instant getSampleTime() {
            return this.sampleTime;
        }

        public final void setSampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
        }

        @Override
        public final Builder sampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
            return this;
        }

        public final Instant getReceivedTime() {
            return this.receivedTime;
        }

        public final void setReceivedTime(Instant receivedTime) {
            this.receivedTime = receivedTime;
        }

        @Override
        public final Builder receivedTime(Instant receivedTime) {
            this.receivedTime = receivedTime;
            return this;
        }

        public final String getDistanceUnit() {
            return this.distanceUnit;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        @Override
        public VerifyDevicePositionResponse build() {
            return new VerifyDevicePositionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyDevicePositionResponse> {
        public Builder inferredState(InferredState var1);

        default public Builder inferredState(Consumer<InferredState.Builder> inferredState) {
            return this.inferredState((InferredState)((InferredState.Builder)InferredState.builder().applyMutation(inferredState)).build());
        }

        public Builder deviceId(String var1);

        public Builder sampleTime(Instant var1);

        public Builder receivedTime(Instant var1);

        public Builder distanceUnit(String var1);

        public Builder distanceUnit(DistanceUnit var1);
    }
}

