/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.location.model.GeofenceGeometry;
import software.amazon.awssdk.services.location.model.PropertyMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGeofenceResponseEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListGeofenceResponseEntry> {
    private static final SdkField<String> GEOFENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeofenceId").getter(ListGeofenceResponseEntry.getter(ListGeofenceResponseEntry::geofenceId)).setter(ListGeofenceResponseEntry.setter(Builder::geofenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceId").build()}).build();
    private static final SdkField<GeofenceGeometry> GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Geometry").getter(ListGeofenceResponseEntry.getter(ListGeofenceResponseEntry::geometry)).setter(ListGeofenceResponseEntry.setter(Builder::geometry)).constructor(GeofenceGeometry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListGeofenceResponseEntry.getter(ListGeofenceResponseEntry::status)).setter(ListGeofenceResponseEntry.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(ListGeofenceResponseEntry.getter(ListGeofenceResponseEntry::createTime)).setter(ListGeofenceResponseEntry.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(ListGeofenceResponseEntry.getter(ListGeofenceResponseEntry::updateTime)).setter(ListGeofenceResponseEntry.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, String>> GEOFENCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("GeofenceProperties").getter(ListGeofenceResponseEntry.getter(ListGeofenceResponseEntry::geofenceProperties)).setter(ListGeofenceResponseEntry.setter(Builder::geofenceProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GEOFENCE_ID_FIELD, GEOMETRY_FIELD, STATUS_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, GEOFENCE_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GeofenceId", GEOFENCE_ID_FIELD);
            this.put("Geometry", GEOMETRY_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("CreateTime", CREATE_TIME_FIELD);
            this.put("UpdateTime", UPDATE_TIME_FIELD);
            this.put("GeofenceProperties", GEOFENCE_PROPERTIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String geofenceId;
    private final GeofenceGeometry geometry;
    private final String status;
    private final Instant createTime;
    private final Instant updateTime;
    private final Map<String, String> geofenceProperties;

    private ListGeofenceResponseEntry(BuilderImpl builder) {
        this.geofenceId = builder.geofenceId;
        this.geometry = builder.geometry;
        this.status = builder.status;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.geofenceProperties = builder.geofenceProperties;
    }

    public final String geofenceId() {
        return this.geofenceId;
    }

    public final GeofenceGeometry geometry() {
        return this.geometry;
    }

    public final String status() {
        return this.status;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final boolean hasGeofenceProperties() {
        return this.geofenceProperties != null && !(this.geofenceProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> geofenceProperties() {
        return this.geofenceProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.geofenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometry());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeofenceProperties() ? this.geofenceProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeofenceResponseEntry)) {
            return false;
        }
        ListGeofenceResponseEntry other = (ListGeofenceResponseEntry)obj;
        return Objects.equals(this.geofenceId(), other.geofenceId()) && Objects.equals(this.geometry(), other.geometry()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && this.hasGeofenceProperties() == other.hasGeofenceProperties() && Objects.equals(this.geofenceProperties(), other.geofenceProperties());
    }

    public final String toString() {
        return ToString.builder((String)"ListGeofenceResponseEntry").add("GeofenceId", (Object)this.geofenceId()).add("Geometry", (Object)this.geometry()).add("Status", (Object)this.status()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("GeofenceProperties", (Object)(this.geofenceProperties() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GeofenceId": {
                return Optional.ofNullable(clazz.cast(this.geofenceId()));
            }
            case "Geometry": {
                return Optional.ofNullable(clazz.cast(this.geometry()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "GeofenceProperties": {
                return Optional.ofNullable(clazz.cast(this.geofenceProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListGeofenceResponseEntry, T> g) {
        return obj -> g.apply((ListGeofenceResponseEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String geofenceId;
        private GeofenceGeometry geometry;
        private String status;
        private Instant createTime;
        private Instant updateTime;
        private Map<String, String> geofenceProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeofenceResponseEntry model) {
            this.geofenceId(model.geofenceId);
            this.geometry(model.geometry);
            this.status(model.status);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.geofenceProperties(model.geofenceProperties);
        }

        public final String getGeofenceId() {
            return this.geofenceId;
        }

        public final void setGeofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
        }

        @Override
        public final Builder geofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
            return this;
        }

        public final GeofenceGeometry.Builder getGeometry() {
            return this.geometry != null ? this.geometry.toBuilder() : null;
        }

        public final void setGeometry(GeofenceGeometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(GeofenceGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final Map<String, String> getGeofenceProperties() {
            if (this.geofenceProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.geofenceProperties;
        }

        public final void setGeofenceProperties(Map<String, String> geofenceProperties) {
            this.geofenceProperties = PropertyMapCopier.copy(geofenceProperties);
        }

        @Override
        public final Builder geofenceProperties(Map<String, String> geofenceProperties) {
            this.geofenceProperties = PropertyMapCopier.copy(geofenceProperties);
            return this;
        }

        public ListGeofenceResponseEntry build() {
            return new ListGeofenceResponseEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListGeofenceResponseEntry> {
        public Builder geofenceId(String var1);

        public Builder geometry(GeofenceGeometry var1);

        default public Builder geometry(Consumer<GeofenceGeometry.Builder> geometry) {
            return this.geometry((GeofenceGeometry)((GeofenceGeometry.Builder)GeofenceGeometry.builder().applyMutation(geometry)).build());
        }

        public Builder status(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder geofenceProperties(Map<String, String> var1);
    }
}

