/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.CustomLayerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MapConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MapConfiguration> {
    private static final SdkField<String> STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Style").getter(MapConfiguration.getter(MapConfiguration::style)).setter(MapConfiguration.setter(Builder::style)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Style").build()}).build();
    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoliticalView").getter(MapConfiguration.getter(MapConfiguration::politicalView)).setter(MapConfiguration.setter(Builder::politicalView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliticalView").build()}).build();
    private static final SdkField<List<String>> CUSTOM_LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomLayers").getter(MapConfiguration.getter(MapConfiguration::customLayers)).setter(MapConfiguration.setter(Builder::customLayers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLayers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STYLE_FIELD, POLITICAL_VIEW_FIELD, CUSTOM_LAYERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Style", STYLE_FIELD);
            this.put("PoliticalView", POLITICAL_VIEW_FIELD);
            this.put("CustomLayers", CUSTOM_LAYERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String style;
    private final String politicalView;
    private final List<String> customLayers;

    private MapConfiguration(BuilderImpl builder) {
        this.style = builder.style;
        this.politicalView = builder.politicalView;
        this.customLayers = builder.customLayers;
    }

    public final String style() {
        return this.style;
    }

    public final String politicalView() {
        return this.politicalView;
    }

    public final boolean hasCustomLayers() {
        return this.customLayers != null && !(this.customLayers instanceof SdkAutoConstructList);
    }

    public final List<String> customLayers() {
        return this.customLayers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.style());
        hashCode = 31 * hashCode + Objects.hashCode(this.politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomLayers() ? this.customLayers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapConfiguration)) {
            return false;
        }
        MapConfiguration other = (MapConfiguration)obj;
        return Objects.equals(this.style(), other.style()) && Objects.equals(this.politicalView(), other.politicalView()) && this.hasCustomLayers() == other.hasCustomLayers() && Objects.equals(this.customLayers(), other.customLayers());
    }

    public final String toString() {
        return ToString.builder((String)"MapConfiguration").add("Style", (Object)this.style()).add("PoliticalView", (Object)this.politicalView()).add("CustomLayers", this.hasCustomLayers() ? this.customLayers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Style": {
                return Optional.ofNullable(clazz.cast(this.style()));
            }
            case "PoliticalView": {
                return Optional.ofNullable(clazz.cast(this.politicalView()));
            }
            case "CustomLayers": {
                return Optional.ofNullable(clazz.cast(this.customLayers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MapConfiguration, T> g) {
        return obj -> g.apply((MapConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String style;
        private String politicalView;
        private List<String> customLayers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MapConfiguration model) {
            this.style(model.style);
            this.politicalView(model.politicalView);
            this.customLayers(model.customLayers);
        }

        public final String getStyle() {
            return this.style;
        }

        public final void setStyle(String style) {
            this.style = style;
        }

        @Override
        public final Builder style(String style) {
            this.style = style;
            return this;
        }

        public final String getPoliticalView() {
            return this.politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final Collection<String> getCustomLayers() {
            if (this.customLayers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customLayers;
        }

        public final void setCustomLayers(Collection<String> customLayers) {
            this.customLayers = CustomLayerListCopier.copy(customLayers);
        }

        @Override
        public final Builder customLayers(Collection<String> customLayers) {
            this.customLayers = CustomLayerListCopier.copy(customLayers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customLayers(String ... customLayers) {
            this.customLayers(Arrays.asList(customLayers));
            return this;
        }

        public MapConfiguration build() {
            return new MapConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MapConfiguration> {
        public Builder style(String var1);

        public Builder politicalView(String var1);

        public Builder customLayers(Collection<String> var1);

        public Builder customLayers(String ... var1);
    }
}

