/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteMatrixErrorCode {
    ROUTE_NOT_FOUND("RouteNotFound"),
    ROUTE_TOO_LONG("RouteTooLong"),
    POSITIONS_NOT_FOUND("PositionsNotFound"),
    DESTINATION_POSITION_NOT_FOUND("DestinationPositionNotFound"),
    DEPARTURE_POSITION_NOT_FOUND("DeparturePositionNotFound"),
    OTHER_VALIDATION_ERROR("OtherValidationError"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteMatrixErrorCode> VALUE_MAP;
    private final String value;

    private RouteMatrixErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteMatrixErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteMatrixErrorCode> knownValues() {
        EnumSet<RouteMatrixErrorCode> knownValues = EnumSet.allOf(RouteMatrixErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteMatrixErrorCode.class, RouteMatrixErrorCode::toString);
    }
}

