/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.CalculateRouteCarModeOptions;
import software.amazon.awssdk.services.location.model.CalculateRouteMatrixRequestDeparturePositionsListCopier;
import software.amazon.awssdk.services.location.model.CalculateRouteMatrixRequestDestinationPositionsListCopier;
import software.amazon.awssdk.services.location.model.CalculateRouteTruckModeOptions;
import software.amazon.awssdk.services.location.model.DistanceUnit;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.TravelMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculateRouteMatrixRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, CalculateRouteMatrixRequest> {
    private static final SdkField<String> CALCULATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatorName").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::calculatorName)).setter(CalculateRouteMatrixRequest.setter(Builder::calculatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CalculatorName").build()}).build();
    private static final SdkField<List<List<Double>>> DEPARTURE_POSITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeparturePositions").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::departurePositions)).setter(CalculateRouteMatrixRequest.setter(Builder::departurePositions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeparturePositions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<List<Double>>> DESTINATION_POSITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationPositions").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::destinationPositions)).setter(CalculateRouteMatrixRequest.setter(Builder::destinationPositions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPositions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> TRAVEL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TravelMode").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::travelModeAsString)).setter(CalculateRouteMatrixRequest.setter(Builder::travelMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelMode").build()}).build();
    private static final SdkField<Instant> DEPARTURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DepartureTime").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::departureTime)).setter(CalculateRouteMatrixRequest.setter(Builder::departureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartureTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> DEPART_NOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DepartNow").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::departNow)).setter(CalculateRouteMatrixRequest.setter(Builder::departNow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartNow").build()}).build();
    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistanceUnit").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::distanceUnitAsString)).setter(CalculateRouteMatrixRequest.setter(Builder::distanceUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()}).build();
    private static final SdkField<CalculateRouteCarModeOptions> CAR_MODE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CarModeOptions").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::carModeOptions)).setter(CalculateRouteMatrixRequest.setter(Builder::carModeOptions)).constructor(CalculateRouteCarModeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarModeOptions").build()}).build();
    private static final SdkField<CalculateRouteTruckModeOptions> TRUCK_MODE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TruckModeOptions").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::truckModeOptions)).setter(CalculateRouteMatrixRequest.setter(Builder::truckModeOptions)).constructor(CalculateRouteTruckModeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckModeOptions").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::key)).setter(CalculateRouteMatrixRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATOR_NAME_FIELD, DEPARTURE_POSITIONS_FIELD, DESTINATION_POSITIONS_FIELD, TRAVEL_MODE_FIELD, DEPARTURE_TIME_FIELD, DEPART_NOW_FIELD, DISTANCE_UNIT_FIELD, CAR_MODE_OPTIONS_FIELD, TRUCK_MODE_OPTIONS_FIELD, KEY_FIELD));
    private final String calculatorName;
    private final List<List<Double>> departurePositions;
    private final List<List<Double>> destinationPositions;
    private final String travelMode;
    private final Instant departureTime;
    private final Boolean departNow;
    private final String distanceUnit;
    private final CalculateRouteCarModeOptions carModeOptions;
    private final CalculateRouteTruckModeOptions truckModeOptions;
    private final String key;

    private CalculateRouteMatrixRequest(BuilderImpl builder) {
        super(builder);
        this.calculatorName = builder.calculatorName;
        this.departurePositions = builder.departurePositions;
        this.destinationPositions = builder.destinationPositions;
        this.travelMode = builder.travelMode;
        this.departureTime = builder.departureTime;
        this.departNow = builder.departNow;
        this.distanceUnit = builder.distanceUnit;
        this.carModeOptions = builder.carModeOptions;
        this.truckModeOptions = builder.truckModeOptions;
        this.key = builder.key;
    }

    public final String calculatorName() {
        return this.calculatorName;
    }

    public final boolean hasDeparturePositions() {
        return this.departurePositions != null && !(this.departurePositions instanceof SdkAutoConstructList);
    }

    public final List<List<Double>> departurePositions() {
        return this.departurePositions;
    }

    public final boolean hasDestinationPositions() {
        return this.destinationPositions != null && !(this.destinationPositions instanceof SdkAutoConstructList);
    }

    public final List<List<Double>> destinationPositions() {
        return this.destinationPositions;
    }

    public final TravelMode travelMode() {
        return TravelMode.fromValue(this.travelMode);
    }

    public final String travelModeAsString() {
        return this.travelMode;
    }

    public final Instant departureTime() {
        return this.departureTime;
    }

    public final Boolean departNow() {
        return this.departNow;
    }

    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(this.distanceUnit);
    }

    public final String distanceUnitAsString() {
        return this.distanceUnit;
    }

    public final CalculateRouteCarModeOptions carModeOptions() {
        return this.carModeOptions;
    }

    public final CalculateRouteTruckModeOptions truckModeOptions() {
        return this.truckModeOptions;
    }

    public final String key() {
        return this.key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeparturePositions() ? this.departurePositions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationPositions() ? this.destinationPositions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.travelModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.departureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.departNow());
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.carModeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.truckModeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteMatrixRequest)) {
            return false;
        }
        CalculateRouteMatrixRequest other = (CalculateRouteMatrixRequest)((Object)obj);
        return Objects.equals(this.calculatorName(), other.calculatorName()) && this.hasDeparturePositions() == other.hasDeparturePositions() && Objects.equals(this.departurePositions(), other.departurePositions()) && this.hasDestinationPositions() == other.hasDestinationPositions() && Objects.equals(this.destinationPositions(), other.destinationPositions()) && Objects.equals(this.travelModeAsString(), other.travelModeAsString()) && Objects.equals(this.departureTime(), other.departureTime()) && Objects.equals(this.departNow(), other.departNow()) && Objects.equals(this.distanceUnitAsString(), other.distanceUnitAsString()) && Objects.equals(this.carModeOptions(), other.carModeOptions()) && Objects.equals(this.truckModeOptions(), other.truckModeOptions()) && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"CalculateRouteMatrixRequest").add("CalculatorName", (Object)this.calculatorName()).add("DeparturePositions", (Object)(this.departurePositions() == null ? null : "*** Sensitive Data Redacted ***")).add("DestinationPositions", (Object)(this.destinationPositions() == null ? null : "*** Sensitive Data Redacted ***")).add("TravelMode", (Object)this.travelModeAsString()).add("DepartureTime", (Object)this.departureTime()).add("DepartNow", (Object)this.departNow()).add("DistanceUnit", (Object)this.distanceUnitAsString()).add("CarModeOptions", (Object)this.carModeOptions()).add("TruckModeOptions", (Object)this.truckModeOptions()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CalculatorName": {
                return Optional.ofNullable(clazz.cast(this.calculatorName()));
            }
            case "DeparturePositions": {
                return Optional.ofNullable(clazz.cast(this.departurePositions()));
            }
            case "DestinationPositions": {
                return Optional.ofNullable(clazz.cast(this.destinationPositions()));
            }
            case "TravelMode": {
                return Optional.ofNullable(clazz.cast(this.travelModeAsString()));
            }
            case "DepartureTime": {
                return Optional.ofNullable(clazz.cast(this.departureTime()));
            }
            case "DepartNow": {
                return Optional.ofNullable(clazz.cast(this.departNow()));
            }
            case "DistanceUnit": {
                return Optional.ofNullable(clazz.cast(this.distanceUnitAsString()));
            }
            case "CarModeOptions": {
                return Optional.ofNullable(clazz.cast(this.carModeOptions()));
            }
            case "TruckModeOptions": {
                return Optional.ofNullable(clazz.cast(this.truckModeOptions()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteMatrixRequest, T> g) {
        return obj -> g.apply((CalculateRouteMatrixRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String calculatorName;
        private List<List<Double>> departurePositions = DefaultSdkAutoConstructList.getInstance();
        private List<List<Double>> destinationPositions = DefaultSdkAutoConstructList.getInstance();
        private String travelMode;
        private Instant departureTime;
        private Boolean departNow;
        private String distanceUnit;
        private CalculateRouteCarModeOptions carModeOptions;
        private CalculateRouteTruckModeOptions truckModeOptions;
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteMatrixRequest model) {
            super(model);
            this.calculatorName(model.calculatorName);
            this.departurePositions(model.departurePositions);
            this.destinationPositions(model.destinationPositions);
            this.travelMode(model.travelMode);
            this.departureTime(model.departureTime);
            this.departNow(model.departNow);
            this.distanceUnit(model.distanceUnit);
            this.carModeOptions(model.carModeOptions);
            this.truckModeOptions(model.truckModeOptions);
            this.key(model.key);
        }

        public final String getCalculatorName() {
            return this.calculatorName;
        }

        public final void setCalculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
        }

        @Override
        public final Builder calculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
            return this;
        }

        public final Collection<? extends Collection<Double>> getDeparturePositions() {
            if (this.departurePositions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.departurePositions;
        }

        public final void setDeparturePositions(Collection<? extends Collection<Double>> departurePositions) {
            this.departurePositions = CalculateRouteMatrixRequestDeparturePositionsListCopier.copy(departurePositions);
        }

        @Override
        public final Builder departurePositions(Collection<? extends Collection<Double>> departurePositions) {
            this.departurePositions = CalculateRouteMatrixRequestDeparturePositionsListCopier.copy(departurePositions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder departurePositions(Collection<Double> ... departurePositions) {
            this.departurePositions((Collection<? extends Collection<Double>>)Arrays.asList(departurePositions));
            return this;
        }

        public final Collection<? extends Collection<Double>> getDestinationPositions() {
            if (this.destinationPositions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinationPositions;
        }

        public final void setDestinationPositions(Collection<? extends Collection<Double>> destinationPositions) {
            this.destinationPositions = CalculateRouteMatrixRequestDestinationPositionsListCopier.copy(destinationPositions);
        }

        @Override
        public final Builder destinationPositions(Collection<? extends Collection<Double>> destinationPositions) {
            this.destinationPositions = CalculateRouteMatrixRequestDestinationPositionsListCopier.copy(destinationPositions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPositions(Collection<Double> ... destinationPositions) {
            this.destinationPositions((Collection<? extends Collection<Double>>)Arrays.asList(destinationPositions));
            return this;
        }

        public final String getTravelMode() {
            return this.travelMode;
        }

        public final void setTravelMode(String travelMode) {
            this.travelMode = travelMode;
        }

        @Override
        public final Builder travelMode(String travelMode) {
            this.travelMode = travelMode;
            return this;
        }

        @Override
        public final Builder travelMode(TravelMode travelMode) {
            this.travelMode(travelMode == null ? null : travelMode.toString());
            return this;
        }

        public final Instant getDepartureTime() {
            return this.departureTime;
        }

        public final void setDepartureTime(Instant departureTime) {
            this.departureTime = departureTime;
        }

        @Override
        public final Builder departureTime(Instant departureTime) {
            this.departureTime = departureTime;
            return this;
        }

        public final Boolean getDepartNow() {
            return this.departNow;
        }

        public final void setDepartNow(Boolean departNow) {
            this.departNow = departNow;
        }

        @Override
        public final Builder departNow(Boolean departNow) {
            this.departNow = departNow;
            return this;
        }

        public final String getDistanceUnit() {
            return this.distanceUnit;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        public final CalculateRouteCarModeOptions.Builder getCarModeOptions() {
            return this.carModeOptions != null ? this.carModeOptions.toBuilder() : null;
        }

        public final void setCarModeOptions(CalculateRouteCarModeOptions.BuilderImpl carModeOptions) {
            this.carModeOptions = carModeOptions != null ? carModeOptions.build() : null;
        }

        @Override
        public final Builder carModeOptions(CalculateRouteCarModeOptions carModeOptions) {
            this.carModeOptions = carModeOptions;
            return this;
        }

        public final CalculateRouteTruckModeOptions.Builder getTruckModeOptions() {
            return this.truckModeOptions != null ? this.truckModeOptions.toBuilder() : null;
        }

        public final void setTruckModeOptions(CalculateRouteTruckModeOptions.BuilderImpl truckModeOptions) {
            this.truckModeOptions = truckModeOptions != null ? truckModeOptions.build() : null;
        }

        @Override
        public final Builder truckModeOptions(CalculateRouteTruckModeOptions truckModeOptions) {
            this.truckModeOptions = truckModeOptions;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CalculateRouteMatrixRequest build() {
            return new CalculateRouteMatrixRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CalculateRouteMatrixRequest> {
        public Builder calculatorName(String var1);

        public Builder departurePositions(Collection<? extends Collection<Double>> var1);

        public Builder departurePositions(Collection<Double> ... var1);

        public Builder destinationPositions(Collection<? extends Collection<Double>> var1);

        public Builder destinationPositions(Collection<Double> ... var1);

        public Builder travelMode(String var1);

        public Builder travelMode(TravelMode var1);

        public Builder departureTime(Instant var1);

        public Builder departNow(Boolean var1);

        public Builder distanceUnit(String var1);

        public Builder distanceUnit(DistanceUnit var1);

        public Builder carModeOptions(CalculateRouteCarModeOptions var1);

        default public Builder carModeOptions(Consumer<CalculateRouteCarModeOptions.Builder> carModeOptions) {
            return this.carModeOptions((CalculateRouteCarModeOptions)((CalculateRouteCarModeOptions.Builder)CalculateRouteCarModeOptions.builder().applyMutation(carModeOptions)).build());
        }

        public Builder truckModeOptions(CalculateRouteTruckModeOptions var1);

        default public Builder truckModeOptions(Consumer<CalculateRouteTruckModeOptions.Builder> truckModeOptions) {
            return this.truckModeOptions((CalculateRouteTruckModeOptions)((CalculateRouteTruckModeOptions.Builder)CalculateRouteTruckModeOptions.builder().applyMutation(truckModeOptions)).build());
        }

        public Builder key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

