/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.MapConfigurationUpdate;
import software.amazon.awssdk.services.location.model.PricingPlan;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMapRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, UpdateMapRequest> {
    private static final SdkField<String> MAP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MapName").getter(UpdateMapRequest.getter(UpdateMapRequest::mapName)).setter(UpdateMapRequest.setter(Builder::mapName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("MapName").build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(UpdateMapRequest.getter(UpdateMapRequest::pricingPlanAsString)).setter(UpdateMapRequest.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateMapRequest.getter(UpdateMapRequest::description)).setter(UpdateMapRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<MapConfigurationUpdate> CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfigurationUpdate").getter(UpdateMapRequest.getter(UpdateMapRequest::configurationUpdate)).setter(UpdateMapRequest.setter(Builder::configurationUpdate)).constructor(MapConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_NAME_FIELD, PRICING_PLAN_FIELD, DESCRIPTION_FIELD, CONFIGURATION_UPDATE_FIELD));
    private final String mapName;
    private final String pricingPlan;
    private final String description;
    private final MapConfigurationUpdate configurationUpdate;

    private UpdateMapRequest(BuilderImpl builder) {
        super(builder);
        this.mapName = builder.mapName;
        this.pricingPlan = builder.pricingPlan;
        this.description = builder.description;
        this.configurationUpdate = builder.configurationUpdate;
    }

    public final String mapName() {
        return this.mapName;
    }

    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(this.pricingPlan);
    }

    @Deprecated
    public final String pricingPlanAsString() {
        return this.pricingPlan;
    }

    public final String description() {
        return this.description;
    }

    public final MapConfigurationUpdate configurationUpdate() {
        return this.configurationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mapName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMapRequest)) {
            return false;
        }
        UpdateMapRequest other = (UpdateMapRequest)((Object)obj);
        return Objects.equals(this.mapName(), other.mapName()) && Objects.equals(this.pricingPlanAsString(), other.pricingPlanAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.configurationUpdate(), other.configurationUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMapRequest").add("MapName", (Object)this.mapName()).add("PricingPlan", (Object)this.pricingPlanAsString()).add("Description", (Object)this.description()).add("ConfigurationUpdate", (Object)this.configurationUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MapName": {
                return Optional.ofNullable(clazz.cast(this.mapName()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.configurationUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMapRequest, T> g) {
        return obj -> g.apply((UpdateMapRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String mapName;
        private String pricingPlan;
        private String description;
        private MapConfigurationUpdate configurationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMapRequest model) {
            super(model);
            this.mapName(model.mapName);
            this.pricingPlan(model.pricingPlan);
            this.description(model.description);
            this.configurationUpdate(model.configurationUpdate);
        }

        public final String getMapName() {
            return this.mapName;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final MapConfigurationUpdate.Builder getConfigurationUpdate() {
            return this.configurationUpdate != null ? this.configurationUpdate.toBuilder() : null;
        }

        public final void setConfigurationUpdate(MapConfigurationUpdate.BuilderImpl configurationUpdate) {
            this.configurationUpdate = configurationUpdate != null ? configurationUpdate.build() : null;
        }

        @Override
        public final Builder configurationUpdate(MapConfigurationUpdate configurationUpdate) {
            this.configurationUpdate = configurationUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMapRequest build() {
            return new UpdateMapRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMapRequest> {
        public Builder mapName(String var1);

        @Deprecated
        public Builder pricingPlan(String var1);

        @Deprecated
        public Builder pricingPlan(PricingPlan var1);

        public Builder description(String var1);

        public Builder configurationUpdate(MapConfigurationUpdate var1);

        default public Builder configurationUpdate(Consumer<MapConfigurationUpdate.Builder> configurationUpdate) {
            return this.configurationUpdate((MapConfigurationUpdate)((MapConfigurationUpdate.Builder)MapConfigurationUpdate.builder().applyMutation(configurationUpdate)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

