/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.CustomLayerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MapConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MapConfiguration> {
    private static final SdkField<List<String>> CUSTOM_LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomLayers").getter(MapConfiguration.getter(MapConfiguration::customLayers)).setter(MapConfiguration.setter(Builder::customLayers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLayers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoliticalView").getter(MapConfiguration.getter(MapConfiguration::politicalView)).setter(MapConfiguration.setter(Builder::politicalView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliticalView").build()}).build();
    private static final SdkField<String> STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Style").getter(MapConfiguration.getter(MapConfiguration::style)).setter(MapConfiguration.setter(Builder::style)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Style").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_LAYERS_FIELD, POLITICAL_VIEW_FIELD, STYLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> customLayers;
    private final String politicalView;
    private final String style;

    private MapConfiguration(BuilderImpl builder) {
        this.customLayers = builder.customLayers;
        this.politicalView = builder.politicalView;
        this.style = builder.style;
    }

    public final boolean hasCustomLayers() {
        return this.customLayers != null && !(this.customLayers instanceof SdkAutoConstructList);
    }

    public final List<String> customLayers() {
        return this.customLayers;
    }

    public final String politicalView() {
        return this.politicalView;
    }

    public final String style() {
        return this.style;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomLayers() ? this.customLayers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(this.style());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapConfiguration)) {
            return false;
        }
        MapConfiguration other = (MapConfiguration)obj;
        return this.hasCustomLayers() == other.hasCustomLayers() && Objects.equals(this.customLayers(), other.customLayers()) && Objects.equals(this.politicalView(), other.politicalView()) && Objects.equals(this.style(), other.style());
    }

    public final String toString() {
        return ToString.builder((String)"MapConfiguration").add("CustomLayers", this.hasCustomLayers() ? this.customLayers() : null).add("PoliticalView", (Object)this.politicalView()).add("Style", (Object)this.style()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomLayers": {
                return Optional.ofNullable(clazz.cast(this.customLayers()));
            }
            case "PoliticalView": {
                return Optional.ofNullable(clazz.cast(this.politicalView()));
            }
            case "Style": {
                return Optional.ofNullable(clazz.cast(this.style()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MapConfiguration, T> g) {
        return obj -> g.apply((MapConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> customLayers = DefaultSdkAutoConstructList.getInstance();
        private String politicalView;
        private String style;

        private BuilderImpl() {
        }

        private BuilderImpl(MapConfiguration model) {
            this.customLayers(model.customLayers);
            this.politicalView(model.politicalView);
            this.style(model.style);
        }

        public final Collection<String> getCustomLayers() {
            if (this.customLayers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customLayers;
        }

        public final void setCustomLayers(Collection<String> customLayers) {
            this.customLayers = CustomLayerListCopier.copy(customLayers);
        }

        @Override
        public final Builder customLayers(Collection<String> customLayers) {
            this.customLayers = CustomLayerListCopier.copy(customLayers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customLayers(String ... customLayers) {
            this.customLayers(Arrays.asList(customLayers));
            return this;
        }

        public final String getPoliticalView() {
            return this.politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final String getStyle() {
            return this.style;
        }

        public final void setStyle(String style) {
            this.style = style;
        }

        @Override
        public final Builder style(String style) {
            this.style = style;
            return this;
        }

        public MapConfiguration build() {
            return new MapConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MapConfiguration> {
        public Builder customLayers(Collection<String> var1);

        public Builder customLayers(String ... var1);

        public Builder politicalView(String var1);

        public Builder style(String var1);
    }
}

