/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationClient;
import software.amazon.awssdk.services.location.internal.UserAgentUtils;
import software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest;
import software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse;
import software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponseEntry;

public class ListRouteCalculatorsIterable
implements SdkIterable<ListRouteCalculatorsResponse> {
    private final LocationClient client;
    private final ListRouteCalculatorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRouteCalculatorsIterable(LocationClient client, ListRouteCalculatorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRouteCalculatorsResponseFetcher();
    }

    public Iterator<ListRouteCalculatorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListRouteCalculatorsResponseEntry> entries() {
        Function<ListRouteCalculatorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entries() != null) {
                return response.entries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRouteCalculatorsResponseFetcher
    implements SyncPageFetcher<ListRouteCalculatorsResponse> {
        private ListRouteCalculatorsResponseFetcher() {
        }

        public boolean hasNextPage(ListRouteCalculatorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRouteCalculatorsResponse nextPage(ListRouteCalculatorsResponse previousPage) {
            if (previousPage == null) {
                return ListRouteCalculatorsIterable.this.client.listRouteCalculators(ListRouteCalculatorsIterable.this.firstRequest);
            }
            return ListRouteCalculatorsIterable.this.client.listRouteCalculators((ListRouteCalculatorsRequest)((Object)ListRouteCalculatorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

