/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.ApiKeyRestrictionsAllowActionsListCopier;
import software.amazon.awssdk.services.location.model.ApiKeyRestrictionsAllowReferersListCopier;
import software.amazon.awssdk.services.location.model.ApiKeyRestrictionsAllowResourcesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiKeyRestrictions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiKeyRestrictions> {
    private static final SdkField<List<String>> ALLOW_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowActions").getter(ApiKeyRestrictions.getter(ApiKeyRestrictions::allowActions)).setter(ApiKeyRestrictions.setter(Builder::allowActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOW_REFERERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowReferers").getter(ApiKeyRestrictions.getter(ApiKeyRestrictions::allowReferers)).setter(ApiKeyRestrictions.setter(Builder::allowReferers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowReferers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOW_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowResources").getter(ApiKeyRestrictions.getter(ApiKeyRestrictions::allowResources)).setter(ApiKeyRestrictions.setter(Builder::allowResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_ACTIONS_FIELD, ALLOW_REFERERS_FIELD, ALLOW_RESOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> allowActions;
    private final List<String> allowReferers;
    private final List<String> allowResources;

    private ApiKeyRestrictions(BuilderImpl builder) {
        this.allowActions = builder.allowActions;
        this.allowReferers = builder.allowReferers;
        this.allowResources = builder.allowResources;
    }

    public final boolean hasAllowActions() {
        return this.allowActions != null && !(this.allowActions instanceof SdkAutoConstructList);
    }

    public final List<String> allowActions() {
        return this.allowActions;
    }

    public final boolean hasAllowReferers() {
        return this.allowReferers != null && !(this.allowReferers instanceof SdkAutoConstructList);
    }

    public final List<String> allowReferers() {
        return this.allowReferers;
    }

    public final boolean hasAllowResources() {
        return this.allowResources != null && !(this.allowResources instanceof SdkAutoConstructList);
    }

    public final List<String> allowResources() {
        return this.allowResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowActions() ? this.allowActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowReferers() ? this.allowReferers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowResources() ? this.allowResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiKeyRestrictions)) {
            return false;
        }
        ApiKeyRestrictions other = (ApiKeyRestrictions)obj;
        return this.hasAllowActions() == other.hasAllowActions() && Objects.equals(this.allowActions(), other.allowActions()) && this.hasAllowReferers() == other.hasAllowReferers() && Objects.equals(this.allowReferers(), other.allowReferers()) && this.hasAllowResources() == other.hasAllowResources() && Objects.equals(this.allowResources(), other.allowResources());
    }

    public final String toString() {
        return ToString.builder((String)"ApiKeyRestrictions").add("AllowActions", this.hasAllowActions() ? this.allowActions() : null).add("AllowReferers", this.hasAllowReferers() ? this.allowReferers() : null).add("AllowResources", this.hasAllowResources() ? this.allowResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowActions": {
                return Optional.ofNullable(clazz.cast(this.allowActions()));
            }
            case "AllowReferers": {
                return Optional.ofNullable(clazz.cast(this.allowReferers()));
            }
            case "AllowResources": {
                return Optional.ofNullable(clazz.cast(this.allowResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApiKeyRestrictions, T> g) {
        return obj -> g.apply((ApiKeyRestrictions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowReferers = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApiKeyRestrictions model) {
            this.allowActions(model.allowActions);
            this.allowReferers(model.allowReferers);
            this.allowResources(model.allowResources);
        }

        public final Collection<String> getAllowActions() {
            if (this.allowActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowActions;
        }

        public final void setAllowActions(Collection<String> allowActions) {
            this.allowActions = ApiKeyRestrictionsAllowActionsListCopier.copy(allowActions);
        }

        @Override
        public final Builder allowActions(Collection<String> allowActions) {
            this.allowActions = ApiKeyRestrictionsAllowActionsListCopier.copy(allowActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowActions(String ... allowActions) {
            this.allowActions(Arrays.asList(allowActions));
            return this;
        }

        public final Collection<String> getAllowReferers() {
            if (this.allowReferers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowReferers;
        }

        public final void setAllowReferers(Collection<String> allowReferers) {
            this.allowReferers = ApiKeyRestrictionsAllowReferersListCopier.copy(allowReferers);
        }

        @Override
        public final Builder allowReferers(Collection<String> allowReferers) {
            this.allowReferers = ApiKeyRestrictionsAllowReferersListCopier.copy(allowReferers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowReferers(String ... allowReferers) {
            this.allowReferers(Arrays.asList(allowReferers));
            return this;
        }

        public final Collection<String> getAllowResources() {
            if (this.allowResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowResources;
        }

        public final void setAllowResources(Collection<String> allowResources) {
            this.allowResources = ApiKeyRestrictionsAllowResourcesListCopier.copy(allowResources);
        }

        @Override
        public final Builder allowResources(Collection<String> allowResources) {
            this.allowResources = ApiKeyRestrictionsAllowResourcesListCopier.copy(allowResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowResources(String ... allowResources) {
            this.allowResources(Arrays.asList(allowResources));
            return this;
        }

        public ApiKeyRestrictions build() {
            return new ApiKeyRestrictions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiKeyRestrictions> {
        public Builder allowActions(Collection<String> var1);

        public Builder allowActions(String ... var1);

        public Builder allowReferers(Collection<String> var1);

        public Builder allowReferers(String ... var1);

        public Builder allowResources(Collection<String> var1);

        public Builder allowResources(String ... var1);
    }
}

