/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationAsyncClient;
import software.amazon.awssdk.services.location.internal.UserAgentUtils;
import software.amazon.awssdk.services.location.model.ListDevicePositionsRequest;
import software.amazon.awssdk.services.location.model.ListDevicePositionsResponse;
import software.amazon.awssdk.services.location.model.ListDevicePositionsResponseEntry;

public class ListDevicePositionsPublisher
implements SdkPublisher<ListDevicePositionsResponse> {
    private final LocationAsyncClient client;
    private final ListDevicePositionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDevicePositionsPublisher(LocationAsyncClient client, ListDevicePositionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDevicePositionsPublisher(LocationAsyncClient client, ListDevicePositionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDevicePositionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDevicePositionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListDevicePositionsResponseEntry> entries() {
        Function<ListDevicePositionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entries() != null) {
                return response.entries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDevicePositionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDevicePositionsResponseFetcher
    implements AsyncPageFetcher<ListDevicePositionsResponse> {
        private ListDevicePositionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevicePositionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDevicePositionsResponse> nextPage(ListDevicePositionsResponse previousPage) {
            if (previousPage == null) {
                return ListDevicePositionsPublisher.this.client.listDevicePositions(ListDevicePositionsPublisher.this.firstRequest);
            }
            return ListDevicePositionsPublisher.this.client.listDevicePositions((ListDevicePositionsRequest)((Object)ListDevicePositionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

