/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.CalculateRouteCarModeOptions;
import software.amazon.awssdk.services.location.model.CalculateRouteRequestWaypointPositionsListCopier;
import software.amazon.awssdk.services.location.model.CalculateRouteTruckModeOptions;
import software.amazon.awssdk.services.location.model.DistanceUnit;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.services.location.model.TravelMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculateRouteRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, CalculateRouteRequest> {
    private static final SdkField<String> CALCULATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatorName").getter(CalculateRouteRequest.getter(CalculateRouteRequest::calculatorName)).setter(CalculateRouteRequest.setter(Builder::calculatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CalculatorName").build()}).build();
    private static final SdkField<CalculateRouteCarModeOptions> CAR_MODE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CarModeOptions").getter(CalculateRouteRequest.getter(CalculateRouteRequest::carModeOptions)).setter(CalculateRouteRequest.setter(Builder::carModeOptions)).constructor(CalculateRouteCarModeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarModeOptions").build()}).build();
    private static final SdkField<Boolean> DEPART_NOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DepartNow").getter(CalculateRouteRequest.getter(CalculateRouteRequest::departNow)).setter(CalculateRouteRequest.setter(Builder::departNow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartNow").build()}).build();
    private static final SdkField<List<Double>> DEPARTURE_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeparturePosition").getter(CalculateRouteRequest.getter(CalculateRouteRequest::departurePosition)).setter(CalculateRouteRequest.setter(Builder::departurePosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeparturePosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> DEPARTURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DepartureTime").getter(CalculateRouteRequest.getter(CalculateRouteRequest::departureTime)).setter(CalculateRouteRequest.setter(Builder::departureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartureTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<Double>> DESTINATION_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationPosition").getter(CalculateRouteRequest.getter(CalculateRouteRequest::destinationPosition)).setter(CalculateRouteRequest.setter(Builder::destinationPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistanceUnit").getter(CalculateRouteRequest.getter(CalculateRouteRequest::distanceUnitAsString)).setter(CalculateRouteRequest.setter(Builder::distanceUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()}).build();
    private static final SdkField<Boolean> INCLUDE_LEG_GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeLegGeometry").getter(CalculateRouteRequest.getter(CalculateRouteRequest::includeLegGeometry)).setter(CalculateRouteRequest.setter(Builder::includeLegGeometry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeLegGeometry").build()}).build();
    private static final SdkField<String> TRAVEL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TravelMode").getter(CalculateRouteRequest.getter(CalculateRouteRequest::travelModeAsString)).setter(CalculateRouteRequest.setter(Builder::travelMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelMode").build()}).build();
    private static final SdkField<CalculateRouteTruckModeOptions> TRUCK_MODE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TruckModeOptions").getter(CalculateRouteRequest.getter(CalculateRouteRequest::truckModeOptions)).setter(CalculateRouteRequest.setter(Builder::truckModeOptions)).constructor(CalculateRouteTruckModeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckModeOptions").build()}).build();
    private static final SdkField<List<List<Double>>> WAYPOINT_POSITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WaypointPositions").getter(CalculateRouteRequest.getter(CalculateRouteRequest::waypointPositions)).setter(CalculateRouteRequest.setter(Builder::waypointPositions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaypointPositions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATOR_NAME_FIELD, CAR_MODE_OPTIONS_FIELD, DEPART_NOW_FIELD, DEPARTURE_POSITION_FIELD, DEPARTURE_TIME_FIELD, DESTINATION_POSITION_FIELD, DISTANCE_UNIT_FIELD, INCLUDE_LEG_GEOMETRY_FIELD, TRAVEL_MODE_FIELD, TRUCK_MODE_OPTIONS_FIELD, WAYPOINT_POSITIONS_FIELD));
    private final String calculatorName;
    private final CalculateRouteCarModeOptions carModeOptions;
    private final Boolean departNow;
    private final List<Double> departurePosition;
    private final Instant departureTime;
    private final List<Double> destinationPosition;
    private final String distanceUnit;
    private final Boolean includeLegGeometry;
    private final String travelMode;
    private final CalculateRouteTruckModeOptions truckModeOptions;
    private final List<List<Double>> waypointPositions;

    private CalculateRouteRequest(BuilderImpl builder) {
        super(builder);
        this.calculatorName = builder.calculatorName;
        this.carModeOptions = builder.carModeOptions;
        this.departNow = builder.departNow;
        this.departurePosition = builder.departurePosition;
        this.departureTime = builder.departureTime;
        this.destinationPosition = builder.destinationPosition;
        this.distanceUnit = builder.distanceUnit;
        this.includeLegGeometry = builder.includeLegGeometry;
        this.travelMode = builder.travelMode;
        this.truckModeOptions = builder.truckModeOptions;
        this.waypointPositions = builder.waypointPositions;
    }

    public final String calculatorName() {
        return this.calculatorName;
    }

    public final CalculateRouteCarModeOptions carModeOptions() {
        return this.carModeOptions;
    }

    public final Boolean departNow() {
        return this.departNow;
    }

    public final boolean hasDeparturePosition() {
        return this.departurePosition != null && !(this.departurePosition instanceof SdkAutoConstructList);
    }

    public final List<Double> departurePosition() {
        return this.departurePosition;
    }

    public final Instant departureTime() {
        return this.departureTime;
    }

    public final boolean hasDestinationPosition() {
        return this.destinationPosition != null && !(this.destinationPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> destinationPosition() {
        return this.destinationPosition;
    }

    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(this.distanceUnit);
    }

    public final String distanceUnitAsString() {
        return this.distanceUnit;
    }

    public final Boolean includeLegGeometry() {
        return this.includeLegGeometry;
    }

    public final TravelMode travelMode() {
        return TravelMode.fromValue(this.travelMode);
    }

    public final String travelModeAsString() {
        return this.travelMode;
    }

    public final CalculateRouteTruckModeOptions truckModeOptions() {
        return this.truckModeOptions;
    }

    public final boolean hasWaypointPositions() {
        return this.waypointPositions != null && !(this.waypointPositions instanceof SdkAutoConstructList);
    }

    public final List<List<Double>> waypointPositions() {
        return this.waypointPositions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.carModeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.departNow());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeparturePosition() ? this.departurePosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.departureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationPosition() ? this.destinationPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeLegGeometry());
        hashCode = 31 * hashCode + Objects.hashCode(this.travelModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.truckModeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWaypointPositions() ? this.waypointPositions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteRequest)) {
            return false;
        }
        CalculateRouteRequest other = (CalculateRouteRequest)((Object)obj);
        return Objects.equals(this.calculatorName(), other.calculatorName()) && Objects.equals(this.carModeOptions(), other.carModeOptions()) && Objects.equals(this.departNow(), other.departNow()) && this.hasDeparturePosition() == other.hasDeparturePosition() && Objects.equals(this.departurePosition(), other.departurePosition()) && Objects.equals(this.departureTime(), other.departureTime()) && this.hasDestinationPosition() == other.hasDestinationPosition() && Objects.equals(this.destinationPosition(), other.destinationPosition()) && Objects.equals(this.distanceUnitAsString(), other.distanceUnitAsString()) && Objects.equals(this.includeLegGeometry(), other.includeLegGeometry()) && Objects.equals(this.travelModeAsString(), other.travelModeAsString()) && Objects.equals(this.truckModeOptions(), other.truckModeOptions()) && this.hasWaypointPositions() == other.hasWaypointPositions() && Objects.equals(this.waypointPositions(), other.waypointPositions());
    }

    public final String toString() {
        return ToString.builder((String)"CalculateRouteRequest").add("CalculatorName", (Object)this.calculatorName()).add("CarModeOptions", (Object)this.carModeOptions()).add("DepartNow", (Object)this.departNow()).add("DeparturePosition", (Object)(this.departurePosition() == null ? null : "*** Sensitive Data Redacted ***")).add("DepartureTime", (Object)this.departureTime()).add("DestinationPosition", (Object)(this.destinationPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("DistanceUnit", (Object)this.distanceUnitAsString()).add("IncludeLegGeometry", (Object)this.includeLegGeometry()).add("TravelMode", (Object)this.travelModeAsString()).add("TruckModeOptions", (Object)this.truckModeOptions()).add("WaypointPositions", (Object)(this.waypointPositions() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CalculatorName": {
                return Optional.ofNullable(clazz.cast(this.calculatorName()));
            }
            case "CarModeOptions": {
                return Optional.ofNullable(clazz.cast(this.carModeOptions()));
            }
            case "DepartNow": {
                return Optional.ofNullable(clazz.cast(this.departNow()));
            }
            case "DeparturePosition": {
                return Optional.ofNullable(clazz.cast(this.departurePosition()));
            }
            case "DepartureTime": {
                return Optional.ofNullable(clazz.cast(this.departureTime()));
            }
            case "DestinationPosition": {
                return Optional.ofNullable(clazz.cast(this.destinationPosition()));
            }
            case "DistanceUnit": {
                return Optional.ofNullable(clazz.cast(this.distanceUnitAsString()));
            }
            case "IncludeLegGeometry": {
                return Optional.ofNullable(clazz.cast(this.includeLegGeometry()));
            }
            case "TravelMode": {
                return Optional.ofNullable(clazz.cast(this.travelModeAsString()));
            }
            case "TruckModeOptions": {
                return Optional.ofNullable(clazz.cast(this.truckModeOptions()));
            }
            case "WaypointPositions": {
                return Optional.ofNullable(clazz.cast(this.waypointPositions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteRequest, T> g) {
        return obj -> g.apply((CalculateRouteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String calculatorName;
        private CalculateRouteCarModeOptions carModeOptions;
        private Boolean departNow;
        private List<Double> departurePosition = DefaultSdkAutoConstructList.getInstance();
        private Instant departureTime;
        private List<Double> destinationPosition = DefaultSdkAutoConstructList.getInstance();
        private String distanceUnit;
        private Boolean includeLegGeometry;
        private String travelMode;
        private CalculateRouteTruckModeOptions truckModeOptions;
        private List<List<Double>> waypointPositions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteRequest model) {
            super(model);
            this.calculatorName(model.calculatorName);
            this.carModeOptions(model.carModeOptions);
            this.departNow(model.departNow);
            this.departurePosition(model.departurePosition);
            this.departureTime(model.departureTime);
            this.destinationPosition(model.destinationPosition);
            this.distanceUnit(model.distanceUnit);
            this.includeLegGeometry(model.includeLegGeometry);
            this.travelMode(model.travelMode);
            this.truckModeOptions(model.truckModeOptions);
            this.waypointPositions(model.waypointPositions);
        }

        public final String getCalculatorName() {
            return this.calculatorName;
        }

        public final void setCalculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
        }

        @Override
        @Transient
        public final Builder calculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
            return this;
        }

        public final CalculateRouteCarModeOptions.Builder getCarModeOptions() {
            return this.carModeOptions != null ? this.carModeOptions.toBuilder() : null;
        }

        public final void setCarModeOptions(CalculateRouteCarModeOptions.BuilderImpl carModeOptions) {
            this.carModeOptions = carModeOptions != null ? carModeOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder carModeOptions(CalculateRouteCarModeOptions carModeOptions) {
            this.carModeOptions = carModeOptions;
            return this;
        }

        public final Boolean getDepartNow() {
            return this.departNow;
        }

        public final void setDepartNow(Boolean departNow) {
            this.departNow = departNow;
        }

        @Override
        @Transient
        public final Builder departNow(Boolean departNow) {
            this.departNow = departNow;
            return this;
        }

        public final Collection<Double> getDeparturePosition() {
            if (this.departurePosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.departurePosition;
        }

        public final void setDeparturePosition(Collection<Double> departurePosition) {
            this.departurePosition = PositionCopier.copy(departurePosition);
        }

        @Override
        @Transient
        public final Builder departurePosition(Collection<Double> departurePosition) {
            this.departurePosition = PositionCopier.copy(departurePosition);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder departurePosition(Double ... departurePosition) {
            this.departurePosition(Arrays.asList(departurePosition));
            return this;
        }

        public final Instant getDepartureTime() {
            return this.departureTime;
        }

        public final void setDepartureTime(Instant departureTime) {
            this.departureTime = departureTime;
        }

        @Override
        @Transient
        public final Builder departureTime(Instant departureTime) {
            this.departureTime = departureTime;
            return this;
        }

        public final Collection<Double> getDestinationPosition() {
            if (this.destinationPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinationPosition;
        }

        public final void setDestinationPosition(Collection<Double> destinationPosition) {
            this.destinationPosition = PositionCopier.copy(destinationPosition);
        }

        @Override
        @Transient
        public final Builder destinationPosition(Collection<Double> destinationPosition) {
            this.destinationPosition = PositionCopier.copy(destinationPosition);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder destinationPosition(Double ... destinationPosition) {
            this.destinationPosition(Arrays.asList(destinationPosition));
            return this;
        }

        public final String getDistanceUnit() {
            return this.distanceUnit;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        @Override
        @Transient
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        @Transient
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        public final Boolean getIncludeLegGeometry() {
            return this.includeLegGeometry;
        }

        public final void setIncludeLegGeometry(Boolean includeLegGeometry) {
            this.includeLegGeometry = includeLegGeometry;
        }

        @Override
        @Transient
        public final Builder includeLegGeometry(Boolean includeLegGeometry) {
            this.includeLegGeometry = includeLegGeometry;
            return this;
        }

        public final String getTravelMode() {
            return this.travelMode;
        }

        public final void setTravelMode(String travelMode) {
            this.travelMode = travelMode;
        }

        @Override
        @Transient
        public final Builder travelMode(String travelMode) {
            this.travelMode = travelMode;
            return this;
        }

        @Override
        @Transient
        public final Builder travelMode(TravelMode travelMode) {
            this.travelMode(travelMode == null ? null : travelMode.toString());
            return this;
        }

        public final CalculateRouteTruckModeOptions.Builder getTruckModeOptions() {
            return this.truckModeOptions != null ? this.truckModeOptions.toBuilder() : null;
        }

        public final void setTruckModeOptions(CalculateRouteTruckModeOptions.BuilderImpl truckModeOptions) {
            this.truckModeOptions = truckModeOptions != null ? truckModeOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder truckModeOptions(CalculateRouteTruckModeOptions truckModeOptions) {
            this.truckModeOptions = truckModeOptions;
            return this;
        }

        public final Collection<? extends Collection<Double>> getWaypointPositions() {
            if (this.waypointPositions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.waypointPositions;
        }

        public final void setWaypointPositions(Collection<? extends Collection<Double>> waypointPositions) {
            this.waypointPositions = CalculateRouteRequestWaypointPositionsListCopier.copy(waypointPositions);
        }

        @Override
        @Transient
        public final Builder waypointPositions(Collection<? extends Collection<Double>> waypointPositions) {
            this.waypointPositions = CalculateRouteRequestWaypointPositionsListCopier.copy(waypointPositions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder waypointPositions(Collection<Double> ... waypointPositions) {
            this.waypointPositions((Collection<? extends Collection<Double>>)Arrays.asList(waypointPositions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CalculateRouteRequest build() {
            return new CalculateRouteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CalculateRouteRequest> {
        public Builder calculatorName(String var1);

        public Builder carModeOptions(CalculateRouteCarModeOptions var1);

        default public Builder carModeOptions(Consumer<CalculateRouteCarModeOptions.Builder> carModeOptions) {
            return this.carModeOptions((CalculateRouteCarModeOptions)((CalculateRouteCarModeOptions.Builder)CalculateRouteCarModeOptions.builder().applyMutation(carModeOptions)).build());
        }

        public Builder departNow(Boolean var1);

        public Builder departurePosition(Collection<Double> var1);

        public Builder departurePosition(Double ... var1);

        public Builder departureTime(Instant var1);

        public Builder destinationPosition(Collection<Double> var1);

        public Builder destinationPosition(Double ... var1);

        public Builder distanceUnit(String var1);

        public Builder distanceUnit(DistanceUnit var1);

        public Builder includeLegGeometry(Boolean var1);

        public Builder travelMode(String var1);

        public Builder travelMode(TravelMode var1);

        public Builder truckModeOptions(CalculateRouteTruckModeOptions var1);

        default public Builder truckModeOptions(Consumer<CalculateRouteTruckModeOptions.Builder> truckModeOptions) {
            return this.truckModeOptions((CalculateRouteTruckModeOptions)((CalculateRouteTruckModeOptions.Builder)CalculateRouteTruckModeOptions.builder().applyMutation(truckModeOptions)).build());
        }

        public Builder waypointPositions(Collection<? extends Collection<Double>> var1);

        public Builder waypointPositions(Collection<Double> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

