/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Step
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Step> {
    private static final SdkField<Double> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Distance").getter(Step.getter(Step::distance)).setter(Step.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<Double> DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DurationSeconds").getter(Step.getter(Step::durationSeconds)).setter(Step.setter(Builder::durationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()}).build();
    private static final SdkField<List<Double>> END_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndPosition").getter(Step.getter(Step::endPosition)).setter(Step.setter(Builder::endPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> GEOMETRY_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GeometryOffset").getter(Step.getter(Step::geometryOffset)).setter(Step.setter(Builder::geometryOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeometryOffset").build()}).build();
    private static final SdkField<List<Double>> START_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StartPosition").getter(Step.getter(Step::startPosition)).setter(Step.setter(Builder::startPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTANCE_FIELD, DURATION_SECONDS_FIELD, END_POSITION_FIELD, GEOMETRY_OFFSET_FIELD, START_POSITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double distance;
    private final Double durationSeconds;
    private final List<Double> endPosition;
    private final Integer geometryOffset;
    private final List<Double> startPosition;

    private Step(BuilderImpl builder) {
        this.distance = builder.distance;
        this.durationSeconds = builder.durationSeconds;
        this.endPosition = builder.endPosition;
        this.geometryOffset = builder.geometryOffset;
        this.startPosition = builder.startPosition;
    }

    public final Double distance() {
        return this.distance;
    }

    public final Double durationSeconds() {
        return this.durationSeconds;
    }

    public final boolean hasEndPosition() {
        return this.endPosition != null && !(this.endPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> endPosition() {
        return this.endPosition;
    }

    public final Integer geometryOffset() {
        return this.geometryOffset;
    }

    public final boolean hasStartPosition() {
        return this.startPosition != null && !(this.startPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> startPosition() {
        return this.startPosition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndPosition() ? this.endPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.geometryOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStartPosition() ? this.startPosition() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Step)) {
            return false;
        }
        Step other = (Step)obj;
        return Objects.equals(this.distance(), other.distance()) && Objects.equals(this.durationSeconds(), other.durationSeconds()) && this.hasEndPosition() == other.hasEndPosition() && Objects.equals(this.endPosition(), other.endPosition()) && Objects.equals(this.geometryOffset(), other.geometryOffset()) && this.hasStartPosition() == other.hasStartPosition() && Objects.equals(this.startPosition(), other.startPosition());
    }

    public final String toString() {
        return ToString.builder((String)"Step").add("Distance", (Object)this.distance()).add("DurationSeconds", (Object)this.durationSeconds()).add("EndPosition", (Object)(this.endPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("GeometryOffset", (Object)this.geometryOffset()).add("StartPosition", (Object)(this.startPosition() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "DurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
            case "EndPosition": {
                return Optional.ofNullable(clazz.cast(this.endPosition()));
            }
            case "GeometryOffset": {
                return Optional.ofNullable(clazz.cast(this.geometryOffset()));
            }
            case "StartPosition": {
                return Optional.ofNullable(clazz.cast(this.startPosition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Step, T> g) {
        return obj -> g.apply((Step)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double distance;
        private Double durationSeconds;
        private List<Double> endPosition = DefaultSdkAutoConstructList.getInstance();
        private Integer geometryOffset;
        private List<Double> startPosition = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Step model) {
            this.distance(model.distance);
            this.durationSeconds(model.durationSeconds);
            this.endPosition(model.endPosition);
            this.geometryOffset(model.geometryOffset);
            this.startPosition(model.startPosition);
        }

        public final Double getDistance() {
            return this.distance;
        }

        @Override
        public final Builder distance(Double distance) {
            this.distance = distance;
            return this;
        }

        public final void setDistance(Double distance) {
            this.distance = distance;
        }

        public final Double getDurationSeconds() {
            return this.durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Double durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Double durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        public final Collection<Double> getEndPosition() {
            if (this.endPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endPosition;
        }

        @Override
        public final Builder endPosition(Collection<Double> endPosition) {
            this.endPosition = PositionCopier.copy(endPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endPosition(Double ... endPosition) {
            this.endPosition(Arrays.asList(endPosition));
            return this;
        }

        public final void setEndPosition(Collection<Double> endPosition) {
            this.endPosition = PositionCopier.copy(endPosition);
        }

        public final Integer getGeometryOffset() {
            return this.geometryOffset;
        }

        @Override
        public final Builder geometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
            return this;
        }

        public final void setGeometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
        }

        public final Collection<Double> getStartPosition() {
            if (this.startPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.startPosition;
        }

        @Override
        public final Builder startPosition(Collection<Double> startPosition) {
            this.startPosition = PositionCopier.copy(startPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startPosition(Double ... startPosition) {
            this.startPosition(Arrays.asList(startPosition));
            return this;
        }

        public final void setStartPosition(Collection<Double> startPosition) {
            this.startPosition = PositionCopier.copy(startPosition);
        }

        public Step build() {
            return new Step(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Step> {
        public Builder distance(Double var1);

        public Builder durationSeconds(Double var1);

        public Builder endPosition(Collection<Double> var1);

        public Builder endPosition(Double ... var1);

        public Builder geometryOffset(Integer var1);

        public Builder startPosition(Collection<Double> var1);

        public Builder startPosition(Double ... var1);
    }
}

