/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationAsyncClient;
import software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest;
import software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse;
import software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponseEntry;

public class ListRouteCalculatorsPublisher
implements SdkPublisher<ListRouteCalculatorsResponse> {
    private final LocationAsyncClient client;
    private final ListRouteCalculatorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRouteCalculatorsPublisher(LocationAsyncClient client, ListRouteCalculatorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRouteCalculatorsPublisher(LocationAsyncClient client, ListRouteCalculatorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRouteCalculatorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRouteCalculatorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListRouteCalculatorsResponseEntry> entries() {
        Function<ListRouteCalculatorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entries() != null) {
                return response.entries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRouteCalculatorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRouteCalculatorsResponseFetcher
    implements AsyncPageFetcher<ListRouteCalculatorsResponse> {
        private ListRouteCalculatorsResponseFetcher() {
        }

        public boolean hasNextPage(ListRouteCalculatorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRouteCalculatorsResponse> nextPage(ListRouteCalculatorsResponse previousPage) {
            if (previousPage == null) {
                return ListRouteCalculatorsPublisher.this.client.listRouteCalculators(ListRouteCalculatorsPublisher.this.firstRequest);
            }
            return ListRouteCalculatorsPublisher.this.client.listRouteCalculators((ListRouteCalculatorsRequest)((Object)ListRouteCalculatorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

