/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRouteCalculatorResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, CreateRouteCalculatorResponse> {
    private static final SdkField<String> CALCULATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatorArn").getter(CreateRouteCalculatorResponse.getter(CreateRouteCalculatorResponse::calculatorArn)).setter(CreateRouteCalculatorResponse.setter(Builder::calculatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatorArn").build()}).build();
    private static final SdkField<String> CALCULATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatorName").getter(CreateRouteCalculatorResponse.getter(CreateRouteCalculatorResponse::calculatorName)).setter(CreateRouteCalculatorResponse.setter(Builder::calculatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatorName").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(CreateRouteCalculatorResponse.getter(CreateRouteCalculatorResponse::createTime)).setter(CreateRouteCalculatorResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATOR_ARN_FIELD, CALCULATOR_NAME_FIELD, CREATE_TIME_FIELD));
    private final String calculatorArn;
    private final String calculatorName;
    private final Instant createTime;

    private CreateRouteCalculatorResponse(BuilderImpl builder) {
        super(builder);
        this.calculatorArn = builder.calculatorArn;
        this.calculatorName = builder.calculatorName;
        this.createTime = builder.createTime;
    }

    public final String calculatorArn() {
        return this.calculatorArn;
    }

    public final String calculatorName() {
        return this.calculatorName;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteCalculatorResponse)) {
            return false;
        }
        CreateRouteCalculatorResponse other = (CreateRouteCalculatorResponse)((Object)obj);
        return Objects.equals(this.calculatorArn(), other.calculatorArn()) && Objects.equals(this.calculatorName(), other.calculatorName()) && Objects.equals(this.createTime(), other.createTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRouteCalculatorResponse").add("CalculatorArn", (Object)this.calculatorArn()).add("CalculatorName", (Object)this.calculatorName()).add("CreateTime", (Object)this.createTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CalculatorArn": {
                return Optional.ofNullable(clazz.cast(this.calculatorArn()));
            }
            case "CalculatorName": {
                return Optional.ofNullable(clazz.cast(this.calculatorName()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteCalculatorResponse, T> g) {
        return obj -> g.apply((CreateRouteCalculatorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private String calculatorArn;
        private String calculatorName;
        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteCalculatorResponse model) {
            super(model);
            this.calculatorArn(model.calculatorArn);
            this.calculatorName(model.calculatorName);
            this.createTime(model.createTime);
        }

        public final String getCalculatorArn() {
            return this.calculatorArn;
        }

        @Override
        public final Builder calculatorArn(String calculatorArn) {
            this.calculatorArn = calculatorArn;
            return this;
        }

        public final void setCalculatorArn(String calculatorArn) {
            this.calculatorArn = calculatorArn;
        }

        public final String getCalculatorName() {
            return this.calculatorName;
        }

        @Override
        public final Builder calculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
            return this;
        }

        public final void setCalculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public CreateRouteCalculatorResponse build() {
            return new CreateRouteCalculatorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRouteCalculatorResponse> {
        public Builder calculatorArn(String var1);

        public Builder calculatorName(String var1);

        public Builder createTime(Instant var1);
    }
}

