/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.BoundingBoxCopier;
import software.amazon.awssdk.services.location.model.DistanceUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculateRouteSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CalculateRouteSummary> {
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSource").getter(CalculateRouteSummary.getter(CalculateRouteSummary::dataSource)).setter(CalculateRouteSummary.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<Double> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Distance").getter(CalculateRouteSummary.getter(CalculateRouteSummary::distance)).setter(CalculateRouteSummary.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistanceUnit").getter(CalculateRouteSummary.getter(CalculateRouteSummary::distanceUnitAsString)).setter(CalculateRouteSummary.setter(Builder::distanceUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()}).build();
    private static final SdkField<Double> DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DurationSeconds").getter(CalculateRouteSummary.getter(CalculateRouteSummary::durationSeconds)).setter(CalculateRouteSummary.setter(Builder::durationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()}).build();
    private static final SdkField<List<Double>> ROUTE_B_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteBBox").getter(CalculateRouteSummary.getter(CalculateRouteSummary::routeBBox)).setter(CalculateRouteSummary.setter(Builder::routeBBox)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteBBox").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, DISTANCE_FIELD, DISTANCE_UNIT_FIELD, DURATION_SECONDS_FIELD, ROUTE_B_BOX_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataSource;
    private final Double distance;
    private final String distanceUnit;
    private final Double durationSeconds;
    private final List<Double> routeBBox;

    private CalculateRouteSummary(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.distance = builder.distance;
        this.distanceUnit = builder.distanceUnit;
        this.durationSeconds = builder.durationSeconds;
        this.routeBBox = builder.routeBBox;
    }

    public final String dataSource() {
        return this.dataSource;
    }

    public final Double distance() {
        return this.distance;
    }

    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(this.distanceUnit);
    }

    public final String distanceUnitAsString() {
        return this.distanceUnit;
    }

    public final Double durationSeconds() {
        return this.durationSeconds;
    }

    public final boolean hasRouteBBox() {
        return this.routeBBox != null && !(this.routeBBox instanceof SdkAutoConstructList);
    }

    public final List<Double> routeBBox() {
        return this.routeBBox;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteBBox() ? this.routeBBox() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteSummary)) {
            return false;
        }
        CalculateRouteSummary other = (CalculateRouteSummary)obj;
        return Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.distance(), other.distance()) && Objects.equals(this.distanceUnitAsString(), other.distanceUnitAsString()) && Objects.equals(this.durationSeconds(), other.durationSeconds()) && this.hasRouteBBox() == other.hasRouteBBox() && Objects.equals(this.routeBBox(), other.routeBBox());
    }

    public final String toString() {
        return ToString.builder((String)"CalculateRouteSummary").add("DataSource", (Object)this.dataSource()).add("Distance", (Object)this.distance()).add("DistanceUnit", (Object)this.distanceUnitAsString()).add("DurationSeconds", (Object)this.durationSeconds()).add("RouteBBox", (Object)(this.routeBBox() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "DistanceUnit": {
                return Optional.ofNullable(clazz.cast(this.distanceUnitAsString()));
            }
            case "DurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
            case "RouteBBox": {
                return Optional.ofNullable(clazz.cast(this.routeBBox()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteSummary, T> g) {
        return obj -> g.apply((CalculateRouteSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSource;
        private Double distance;
        private String distanceUnit;
        private Double durationSeconds;
        private List<Double> routeBBox = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteSummary model) {
            this.dataSource(model.dataSource);
            this.distance(model.distance);
            this.distanceUnit(model.distanceUnit);
            this.durationSeconds(model.durationSeconds);
            this.routeBBox(model.routeBBox);
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final Double getDistance() {
            return this.distance;
        }

        @Override
        public final Builder distance(Double distance) {
            this.distance = distance;
            return this;
        }

        public final void setDistance(Double distance) {
            this.distance = distance;
        }

        public final String getDistanceUnit() {
            return this.distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        public final Double getDurationSeconds() {
            return this.durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Double durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Double durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        public final Collection<Double> getRouteBBox() {
            if (this.routeBBox instanceof SdkAutoConstructList) {
                return null;
            }
            return this.routeBBox;
        }

        @Override
        public final Builder routeBBox(Collection<Double> routeBBox) {
            this.routeBBox = BoundingBoxCopier.copy(routeBBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeBBox(Double ... routeBBox) {
            this.routeBBox(Arrays.asList(routeBBox));
            return this;
        }

        public final void setRouteBBox(Collection<Double> routeBBox) {
            this.routeBBox = BoundingBoxCopier.copy(routeBBox);
        }

        public CalculateRouteSummary build() {
            return new CalculateRouteSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CalculateRouteSummary> {
        public Builder dataSource(String var1);

        public Builder distance(Double var1);

        public Builder distanceUnit(String var1);

        public Builder distanceUnit(DistanceUnit var1);

        public Builder durationSeconds(Double var1);

        public Builder routeBBox(Collection<Double> var1);

        public Builder routeBBox(Double ... var1);
    }
}

