/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.PortInfoSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceEntry> {
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceEntry.getter(InstanceEntry::sourceName)).setter(InstanceEntry.setter(Builder::sourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceEntry.getter(InstanceEntry::instanceType)).setter(InstanceEntry.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> PORT_INFO_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceEntry.getter(InstanceEntry::portInfoSourceAsString)).setter(InstanceEntry.setter(Builder::portInfoSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portInfoSource").build()}).build();
    private static final SdkField<String> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceEntry.getter(InstanceEntry::userData)).setter(InstanceEntry.setter(Builder::userData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userData").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceEntry.getter(InstanceEntry::availabilityZone)).setter(InstanceEntry.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_NAME_FIELD, INSTANCE_TYPE_FIELD, PORT_INFO_SOURCE_FIELD, USER_DATA_FIELD, AVAILABILITY_ZONE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceName;
    private final String instanceType;
    private final String portInfoSource;
    private final String userData;
    private final String availabilityZone;

    private InstanceEntry(BuilderImpl builder) {
        this.sourceName = builder.sourceName;
        this.instanceType = builder.instanceType;
        this.portInfoSource = builder.portInfoSource;
        this.userData = builder.userData;
        this.availabilityZone = builder.availabilityZone;
    }

    public String sourceName() {
        return this.sourceName;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public PortInfoSourceType portInfoSource() {
        return PortInfoSourceType.fromValue(this.portInfoSource);
    }

    public String portInfoSourceAsString() {
        return this.portInfoSource;
    }

    public String userData() {
        return this.userData;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.portInfoSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceEntry)) {
            return false;
        }
        InstanceEntry other = (InstanceEntry)obj;
        return Objects.equals(this.sourceName(), other.sourceName()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.portInfoSourceAsString(), other.portInfoSourceAsString()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.availabilityZone(), other.availabilityZone());
    }

    public String toString() {
        return ToString.builder((String)"InstanceEntry").add("SourceName", (Object)this.sourceName()).add("InstanceType", (Object)this.instanceType()).add("PortInfoSource", (Object)this.portInfoSourceAsString()).add("UserData", (Object)this.userData()).add("AvailabilityZone", (Object)this.availabilityZone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceName": {
                return Optional.ofNullable(clazz.cast(this.sourceName()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "portInfoSource": {
                return Optional.ofNullable(clazz.cast(this.portInfoSourceAsString()));
            }
            case "userData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceEntry, T> g) {
        return obj -> g.apply((InstanceEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceName;
        private String instanceType;
        private String portInfoSource;
        private String userData;
        private String availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceEntry model) {
            this.sourceName(model.sourceName);
            this.instanceType(model.instanceType);
            this.portInfoSource(model.portInfoSource);
            this.userData(model.userData);
            this.availabilityZone(model.availabilityZone);
        }

        public final String getSourceName() {
            return this.sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getPortInfoSourceAsString() {
            return this.portInfoSource;
        }

        @Override
        public final Builder portInfoSource(String portInfoSource) {
            this.portInfoSource = portInfoSource;
            return this;
        }

        @Override
        public final Builder portInfoSource(PortInfoSourceType portInfoSource) {
            this.portInfoSource(portInfoSource == null ? null : portInfoSource.toString());
            return this;
        }

        public final void setPortInfoSource(String portInfoSource) {
            this.portInfoSource = portInfoSource;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public InstanceEntry build() {
            return new InstanceEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceEntry> {
        public Builder sourceName(String var1);

        public Builder instanceType(String var1);

        public Builder portInfoSource(String var1);

        public Builder portInfoSource(PortInfoSourceType var1);

        public Builder userData(String var1);

        public Builder availabilityZone(String var1);
    }
}

