/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.DomainNameListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLoadBalancerRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateLoadBalancerRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::loadBalancerName)).setter(CreateLoadBalancerRequest.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerName").build()}).build();
    private static final SdkField<Integer> INSTANCE_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::instancePort)).setter(CreateLoadBalancerRequest.setter(Builder::instancePort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instancePort").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::healthCheckPath)).setter(CreateLoadBalancerRequest.setter(Builder::healthCheckPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckPath").build()}).build();
    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::certificateName)).setter(CreateLoadBalancerRequest.setter(Builder::certificateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()}).build();
    private static final SdkField<String> CERTIFICATE_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::certificateDomainName)).setter(CreateLoadBalancerRequest.setter(Builder::certificateDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateDomainName").build()}).build();
    private static final SdkField<List<String>> CERTIFICATE_ALTERNATIVE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::certificateAlternativeNames)).setter(CreateLoadBalancerRequest.setter(Builder::certificateAlternativeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateAlternativeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::tags)).setter(CreateLoadBalancerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD, INSTANCE_PORT_FIELD, HEALTH_CHECK_PATH_FIELD, CERTIFICATE_NAME_FIELD, CERTIFICATE_DOMAIN_NAME_FIELD, CERTIFICATE_ALTERNATIVE_NAMES_FIELD, TAGS_FIELD));
    private final String loadBalancerName;
    private final Integer instancePort;
    private final String healthCheckPath;
    private final String certificateName;
    private final String certificateDomainName;
    private final List<String> certificateAlternativeNames;
    private final List<Tag> tags;

    private CreateLoadBalancerRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.instancePort = builder.instancePort;
        this.healthCheckPath = builder.healthCheckPath;
        this.certificateName = builder.certificateName;
        this.certificateDomainName = builder.certificateDomainName;
        this.certificateAlternativeNames = builder.certificateAlternativeNames;
        this.tags = builder.tags;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public Integer instancePort() {
        return this.instancePort;
    }

    public String healthCheckPath() {
        return this.healthCheckPath;
    }

    public String certificateName() {
        return this.certificateName;
    }

    public String certificateDomainName() {
        return this.certificateDomainName;
    }

    public List<String> certificateAlternativeNames() {
        return this.certificateAlternativeNames;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAlternativeNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerRequest)) {
            return false;
        }
        CreateLoadBalancerRequest other = (CreateLoadBalancerRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.instancePort(), other.instancePort()) && Objects.equals(this.healthCheckPath(), other.healthCheckPath()) && Objects.equals(this.certificateName(), other.certificateName()) && Objects.equals(this.certificateDomainName(), other.certificateDomainName()) && Objects.equals(this.certificateAlternativeNames(), other.certificateAlternativeNames()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateLoadBalancerRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("InstancePort", (Object)this.instancePort()).add("HealthCheckPath", (Object)this.healthCheckPath()).add("CertificateName", (Object)this.certificateName()).add("CertificateDomainName", (Object)this.certificateDomainName()).add("CertificateAlternativeNames", this.certificateAlternativeNames()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "loadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "instancePort": {
                return Optional.ofNullable(clazz.cast(this.instancePort()));
            }
            case "healthCheckPath": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPath()));
            }
            case "certificateName": {
                return Optional.ofNullable(clazz.cast(this.certificateName()));
            }
            case "certificateDomainName": {
                return Optional.ofNullable(clazz.cast(this.certificateDomainName()));
            }
            case "certificateAlternativeNames": {
                return Optional.ofNullable(clazz.cast(this.certificateAlternativeNames()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLoadBalancerRequest, T> g) {
        return obj -> g.apply((CreateLoadBalancerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private Integer instancePort;
        private String healthCheckPath;
        private String certificateName;
        private String certificateDomainName;
        private List<String> certificateAlternativeNames = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.instancePort(model.instancePort);
            this.healthCheckPath(model.healthCheckPath);
            this.certificateName(model.certificateName);
            this.certificateDomainName(model.certificateDomainName);
            this.certificateAlternativeNames(model.certificateAlternativeNames);
            this.tags(model.tags);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Integer getInstancePort() {
            return this.instancePort;
        }

        @Override
        public final Builder instancePort(Integer instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        public final void setInstancePort(Integer instancePort) {
            this.instancePort = instancePort;
        }

        public final String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public final String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final String getCertificateDomainName() {
            return this.certificateDomainName;
        }

        @Override
        public final Builder certificateDomainName(String certificateDomainName) {
            this.certificateDomainName = certificateDomainName;
            return this;
        }

        public final void setCertificateDomainName(String certificateDomainName) {
            this.certificateDomainName = certificateDomainName;
        }

        public final Collection<String> getCertificateAlternativeNames() {
            return this.certificateAlternativeNames;
        }

        @Override
        public final Builder certificateAlternativeNames(Collection<String> certificateAlternativeNames) {
            this.certificateAlternativeNames = DomainNameListCopier.copy(certificateAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAlternativeNames(String ... certificateAlternativeNames) {
            this.certificateAlternativeNames(Arrays.asList(certificateAlternativeNames));
            return this;
        }

        public final void setCertificateAlternativeNames(Collection<String> certificateAlternativeNames) {
            this.certificateAlternativeNames = DomainNameListCopier.copy(certificateAlternativeNames);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLoadBalancerRequest build() {
            return new CreateLoadBalancerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLoadBalancerRequest> {
        public Builder loadBalancerName(String var1);

        public Builder instancePort(Integer var1);

        public Builder healthCheckPath(String var1);

        public Builder certificateName(String var1);

        public Builder certificateDomainName(String var1);

        public Builder certificateAlternativeNames(Collection<String> var1);

        public Builder certificateAlternativeNames(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

