/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.RegionName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopySnapshotRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CopySnapshotRequest> {
    private static final SdkField<String> SOURCE_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopySnapshotRequest.getter(CopySnapshotRequest::sourceSnapshotName)).setter(CopySnapshotRequest.setter(Builder::sourceSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSnapshotName").build()}).build();
    private static final SdkField<String> TARGET_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopySnapshotRequest.getter(CopySnapshotRequest::targetSnapshotName)).setter(CopySnapshotRequest.setter(Builder::targetSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSnapshotName").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopySnapshotRequest.getter(CopySnapshotRequest::sourceRegionAsString)).setter(CopySnapshotRequest.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SNAPSHOT_NAME_FIELD, TARGET_SNAPSHOT_NAME_FIELD, SOURCE_REGION_FIELD));
    private final String sourceSnapshotName;
    private final String targetSnapshotName;
    private final String sourceRegion;

    private CopySnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceSnapshotName = builder.sourceSnapshotName;
        this.targetSnapshotName = builder.targetSnapshotName;
        this.sourceRegion = builder.sourceRegion;
    }

    public String sourceSnapshotName() {
        return this.sourceSnapshotName;
    }

    public String targetSnapshotName() {
        return this.targetSnapshotName;
    }

    public RegionName sourceRegion() {
        return RegionName.fromValue(this.sourceRegion);
    }

    public String sourceRegionAsString() {
        return this.sourceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotRequest)) {
            return false;
        }
        CopySnapshotRequest other = (CopySnapshotRequest)((Object)obj);
        return Objects.equals(this.sourceSnapshotName(), other.sourceSnapshotName()) && Objects.equals(this.targetSnapshotName(), other.targetSnapshotName()) && Objects.equals(this.sourceRegionAsString(), other.sourceRegionAsString());
    }

    public String toString() {
        return ToString.builder((String)"CopySnapshotRequest").add("SourceSnapshotName", (Object)this.sourceSnapshotName()).add("TargetSnapshotName", (Object)this.targetSnapshotName()).add("SourceRegion", (Object)this.sourceRegionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.sourceSnapshotName()));
            }
            case "targetSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.targetSnapshotName()));
            }
            case "sourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopySnapshotRequest, T> g) {
        return obj -> g.apply((CopySnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String sourceSnapshotName;
        private String targetSnapshotName;
        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CopySnapshotRequest model) {
            super(model);
            this.sourceSnapshotName(model.sourceSnapshotName);
            this.targetSnapshotName(model.targetSnapshotName);
            this.sourceRegion(model.sourceRegion);
        }

        public final String getSourceSnapshotName() {
            return this.sourceSnapshotName;
        }

        @Override
        public final Builder sourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
            return this;
        }

        public final void setSourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
        }

        public final String getTargetSnapshotName() {
            return this.targetSnapshotName;
        }

        @Override
        public final Builder targetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
            return this;
        }

        public final void setTargetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
        }

        public final String getSourceRegionAsString() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        @Override
        public final Builder sourceRegion(RegionName sourceRegion) {
            this.sourceRegion(sourceRegion.toString());
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopySnapshotRequest build() {
            return new CopySnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopySnapshotRequest> {
        public Builder sourceSnapshotName(String var1);

        public Builder targetSnapshotName(String var1);

        public Builder sourceRegion(String var1);

        public Builder sourceRegion(RegionName var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

