/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InstanceHealthReason {
    LB_REGISTRATION_IN_PROGRESS("Lb.RegistrationInProgress"),
    LB_INITIAL_HEALTH_CHECKING("Lb.InitialHealthChecking"),
    LB_INTERNAL_ERROR("Lb.InternalError"),
    INSTANCE_RESPONSE_CODE_MISMATCH("Instance.ResponseCodeMismatch"),
    INSTANCE_TIMEOUT("Instance.Timeout"),
    INSTANCE_FAILED_HEALTH_CHECKS("Instance.FailedHealthChecks"),
    INSTANCE_NOT_REGISTERED("Instance.NotRegistered"),
    INSTANCE_NOT_IN_USE("Instance.NotInUse"),
    INSTANCE_DEREGISTRATION_IN_PROGRESS("Instance.DeregistrationInProgress"),
    INSTANCE_INVALID_STATE("Instance.InvalidState"),
    INSTANCE_IP_UNUSABLE("Instance.IpUnusable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InstanceHealthReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceHealthReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InstanceHealthReason.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceHealthReason> knownValues() {
        return Stream.of(InstanceHealthReason.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

