/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.lightsail.model.DomainEntryOptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainEntry> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainEntry.getter(DomainEntry::id)).setter(DomainEntry.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainEntry.getter(DomainEntry::name)).setter(DomainEntry.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainEntry.getter(DomainEntry::target)).setter(DomainEntry.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<Boolean> IS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DomainEntry.getter(DomainEntry::isAlias)).setter(DomainEntry.setter(Builder::isAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAlias").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainEntry.getter(DomainEntry::type)).setter(DomainEntry.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Map<String, String>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DomainEntry.getter(DomainEntry::options)).setter(DomainEntry.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, TARGET_FIELD, IS_ALIAS_FIELD, TYPE_FIELD, OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String target;
    private final Boolean isAlias;
    private final String type;
    private final Map<String, String> options;

    private DomainEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.target = builder.target;
        this.isAlias = builder.isAlias;
        this.type = builder.type;
        this.options = builder.options;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String target() {
        return this.target;
    }

    public Boolean isAlias() {
        return this.isAlias;
    }

    public String type() {
        return this.type;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainEntry)) {
            return false;
        }
        DomainEntry other = (DomainEntry)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.isAlias(), other.isAlias()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.options(), other.options());
    }

    public String toString() {
        return ToString.builder((String)"DomainEntry").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Target", (Object)this.target()).add("IsAlias", (Object)this.isAlias()).add("Type", (Object)this.type()).add("Options", this.options()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "isAlias": {
                return Optional.ofNullable(clazz.cast(this.isAlias()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainEntry, T> g) {
        return obj -> g.apply((DomainEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String target;
        private Boolean isAlias;
        private String type;
        private Map<String, String> options = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DomainEntry model) {
            this.id(model.id);
            this.name(model.name);
            this.target(model.target);
            this.isAlias(model.isAlias);
            this.type(model.type);
            this.options(model.options);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final Boolean getIsAlias() {
            return this.isAlias;
        }

        @Override
        public final Builder isAlias(Boolean isAlias) {
            this.isAlias = isAlias;
            return this;
        }

        public final void setIsAlias(Boolean isAlias) {
            this.isAlias = isAlias;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getOptions() {
            return this.options;
        }

        @Override
        public final Builder options(Map<String, String> options) {
            this.options = DomainEntryOptionsCopier.copy(options);
            return this;
        }

        public final void setOptions(Map<String, String> options) {
            this.options = DomainEntryOptionsCopier.copy(options);
        }

        public DomainEntry build() {
            return new DomainEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainEntry> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder target(String var1);

        public Builder isAlias(Boolean var1);

        public Builder type(String var1);

        public Builder options(Map<String, String> var1);
    }
}

