/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEventListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRelationalDatabaseEventsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetRelationalDatabaseEventsResponse> {
    private static final SdkField<List<RelationalDatabaseEvent>> RELATIONAL_DATABASE_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relationalDatabaseEvents").getter(GetRelationalDatabaseEventsResponse.getter(GetRelationalDatabaseEventsResponse::relationalDatabaseEvents)).setter(GetRelationalDatabaseEventsResponse.setter(Builder::relationalDatabaseEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelationalDatabaseEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetRelationalDatabaseEventsResponse.getter(GetRelationalDatabaseEventsResponse::nextPageToken)).setter(GetRelationalDatabaseEventsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_DATABASE_EVENTS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRelationalDatabaseEventsResponse.memberNameToFieldInitializer();
    private final List<RelationalDatabaseEvent> relationalDatabaseEvents;
    private final String nextPageToken;

    private GetRelationalDatabaseEventsResponse(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseEvents = builder.relationalDatabaseEvents;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasRelationalDatabaseEvents() {
        return this.relationalDatabaseEvents != null && !(this.relationalDatabaseEvents instanceof SdkAutoConstructList);
    }

    public final List<RelationalDatabaseEvent> relationalDatabaseEvents() {
        return this.relationalDatabaseEvents;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelationalDatabaseEvents() ? this.relationalDatabaseEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseEventsResponse)) {
            return false;
        }
        GetRelationalDatabaseEventsResponse other = (GetRelationalDatabaseEventsResponse)((Object)obj);
        return this.hasRelationalDatabaseEvents() == other.hasRelationalDatabaseEvents() && Objects.equals(this.relationalDatabaseEvents(), other.relationalDatabaseEvents()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetRelationalDatabaseEventsResponse").add("RelationalDatabaseEvents", this.hasRelationalDatabaseEvents() ? this.relationalDatabaseEvents() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relationalDatabaseEvents": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseEvents()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("relationalDatabaseEvents", RELATIONAL_DATABASE_EVENTS_FIELD);
        map.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseEventsResponse, T> g) {
        return obj -> g.apply((GetRelationalDatabaseEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<RelationalDatabaseEvent> relationalDatabaseEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseEventsResponse model) {
            super(model);
            this.relationalDatabaseEvents(model.relationalDatabaseEvents);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<RelationalDatabaseEvent.Builder> getRelationalDatabaseEvents() {
            List<RelationalDatabaseEvent.Builder> result = RelationalDatabaseEventListCopier.copyToBuilder(this.relationalDatabaseEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelationalDatabaseEvents(Collection<RelationalDatabaseEvent.BuilderImpl> relationalDatabaseEvents) {
            this.relationalDatabaseEvents = RelationalDatabaseEventListCopier.copyFromBuilder(relationalDatabaseEvents);
        }

        @Override
        public final Builder relationalDatabaseEvents(Collection<RelationalDatabaseEvent> relationalDatabaseEvents) {
            this.relationalDatabaseEvents = RelationalDatabaseEventListCopier.copy(relationalDatabaseEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabaseEvents(RelationalDatabaseEvent ... relationalDatabaseEvents) {
            this.relationalDatabaseEvents(Arrays.asList(relationalDatabaseEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabaseEvents(Consumer<RelationalDatabaseEvent.Builder> ... relationalDatabaseEvents) {
            this.relationalDatabaseEvents(Stream.of(relationalDatabaseEvents).map(c -> (RelationalDatabaseEvent)((RelationalDatabaseEvent.Builder)RelationalDatabaseEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetRelationalDatabaseEventsResponse build() {
            return new GetRelationalDatabaseEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRelationalDatabaseEventsResponse> {
        public Builder relationalDatabaseEvents(Collection<RelationalDatabaseEvent> var1);

        public Builder relationalDatabaseEvents(RelationalDatabaseEvent ... var1);

        public Builder relationalDatabaseEvents(Consumer<RelationalDatabaseEvent.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

