/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.HostKeyAttributes;
import software.amazon.awssdk.services.lightsail.model.HostKeysListCopier;
import software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol;
import software.amazon.awssdk.services.lightsail.model.Ipv6AddressListCopier;
import software.amazon.awssdk.services.lightsail.model.PasswordData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceAccessDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceAccessDetails> {
    private static final SdkField<String> CERT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certKey").getter(InstanceAccessDetails.getter(InstanceAccessDetails::certKey)).setter(InstanceAccessDetails.setter(Builder::certKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certKey").build()}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiresAt").getter(InstanceAccessDetails.getter(InstanceAccessDetails::expiresAt)).setter(InstanceAccessDetails.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddress").getter(InstanceAccessDetails.getter(InstanceAccessDetails::ipAddress)).setter(InstanceAccessDetails.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()}).build();
    private static final SdkField<List<String>> IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ipv6Addresses").getter(InstanceAccessDetails.getter(InstanceAccessDetails::ipv6Addresses)).setter(InstanceAccessDetails.setter(Builder::ipv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv6Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("password").getter(InstanceAccessDetails.getter(InstanceAccessDetails::password)).setter(InstanceAccessDetails.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("password").build()}).build();
    private static final SdkField<PasswordData> PASSWORD_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("passwordData").getter(InstanceAccessDetails.getter(InstanceAccessDetails::passwordData)).setter(InstanceAccessDetails.setter(Builder::passwordData)).constructor(PasswordData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passwordData").build()}).build();
    private static final SdkField<String> PRIVATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privateKey").getter(InstanceAccessDetails.getter(InstanceAccessDetails::privateKey)).setter(InstanceAccessDetails.setter(Builder::privateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateKey").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(InstanceAccessDetails.getter(InstanceAccessDetails::protocolAsString)).setter(InstanceAccessDetails.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceName").getter(InstanceAccessDetails.getter(InstanceAccessDetails::instanceName)).setter(InstanceAccessDetails.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(InstanceAccessDetails.getter(InstanceAccessDetails::username)).setter(InstanceAccessDetails.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<List<HostKeyAttributes>> HOST_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("hostKeys").getter(InstanceAccessDetails.getter(InstanceAccessDetails::hostKeys)).setter(InstanceAccessDetails.setter(Builder::hostKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HostKeyAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERT_KEY_FIELD, EXPIRES_AT_FIELD, IP_ADDRESS_FIELD, IPV6_ADDRESSES_FIELD, PASSWORD_FIELD, PASSWORD_DATA_FIELD, PRIVATE_KEY_FIELD, PROTOCOL_FIELD, INSTANCE_NAME_FIELD, USERNAME_FIELD, HOST_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceAccessDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String certKey;
    private final Instant expiresAt;
    private final String ipAddress;
    private final List<String> ipv6Addresses;
    private final String password;
    private final PasswordData passwordData;
    private final String privateKey;
    private final String protocol;
    private final String instanceName;
    private final String username;
    private final List<HostKeyAttributes> hostKeys;

    private InstanceAccessDetails(BuilderImpl builder) {
        this.certKey = builder.certKey;
        this.expiresAt = builder.expiresAt;
        this.ipAddress = builder.ipAddress;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.password = builder.password;
        this.passwordData = builder.passwordData;
        this.privateKey = builder.privateKey;
        this.protocol = builder.protocol;
        this.instanceName = builder.instanceName;
        this.username = builder.username;
        this.hostKeys = builder.hostKeys;
    }

    public final String certKey() {
        return this.certKey;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final boolean hasIpv6Addresses() {
        return this.ipv6Addresses != null && !(this.ipv6Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public final String password() {
        return this.password;
    }

    public final PasswordData passwordData() {
        return this.passwordData;
    }

    public final String privateKey() {
        return this.privateKey;
    }

    public final InstanceAccessProtocol protocol() {
        return InstanceAccessProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final String instanceName() {
        return this.instanceName;
    }

    public final String username() {
        return this.username;
    }

    public final boolean hasHostKeys() {
        return this.hostKeys != null && !(this.hostKeys instanceof SdkAutoConstructList);
    }

    public final List<HostKeyAttributes> hostKeys() {
        return this.hostKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Addresses() ? this.ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordData());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHostKeys() ? this.hostKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAccessDetails)) {
            return false;
        }
        InstanceAccessDetails other = (InstanceAccessDetails)obj;
        return Objects.equals(this.certKey(), other.certKey()) && Objects.equals(this.expiresAt(), other.expiresAt()) && Objects.equals(this.ipAddress(), other.ipAddress()) && this.hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.passwordData(), other.passwordData()) && Objects.equals(this.privateKey(), other.privateKey()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.username(), other.username()) && this.hasHostKeys() == other.hasHostKeys() && Objects.equals(this.hostKeys(), other.hostKeys());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceAccessDetails").add("CertKey", (Object)this.certKey()).add("ExpiresAt", (Object)this.expiresAt()).add("IpAddress", (Object)this.ipAddress()).add("Ipv6Addresses", this.hasIpv6Addresses() ? this.ipv6Addresses() : null).add("Password", (Object)this.password()).add("PasswordData", (Object)this.passwordData()).add("PrivateKey", (Object)this.privateKey()).add("Protocol", (Object)this.protocolAsString()).add("InstanceName", (Object)this.instanceName()).add("Username", (Object)this.username()).add("HostKeys", this.hasHostKeys() ? this.hostKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certKey": {
                return Optional.ofNullable(clazz.cast(this.certKey()));
            }
            case "expiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
            case "ipAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "ipv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv6Addresses()));
            }
            case "password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "passwordData": {
                return Optional.ofNullable(clazz.cast(this.passwordData()));
            }
            case "privateKey": {
                return Optional.ofNullable(clazz.cast(this.privateKey()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "hostKeys": {
                return Optional.ofNullable(clazz.cast(this.hostKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("certKey", CERT_KEY_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        map.put("ipAddress", IP_ADDRESS_FIELD);
        map.put("ipv6Addresses", IPV6_ADDRESSES_FIELD);
        map.put("password", PASSWORD_FIELD);
        map.put("passwordData", PASSWORD_DATA_FIELD);
        map.put("privateKey", PRIVATE_KEY_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("instanceName", INSTANCE_NAME_FIELD);
        map.put("username", USERNAME_FIELD);
        map.put("hostKeys", HOST_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceAccessDetails, T> g) {
        return obj -> g.apply((InstanceAccessDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certKey;
        private Instant expiresAt;
        private String ipAddress;
        private List<String> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private String password;
        private PasswordData passwordData;
        private String privateKey;
        private String protocol;
        private String instanceName;
        private String username;
        private List<HostKeyAttributes> hostKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAccessDetails model) {
            this.certKey(model.certKey);
            this.expiresAt(model.expiresAt);
            this.ipAddress(model.ipAddress);
            this.ipv6Addresses(model.ipv6Addresses);
            this.password(model.password);
            this.passwordData(model.passwordData);
            this.privateKey(model.privateKey);
            this.protocol(model.protocol);
            this.instanceName(model.instanceName);
            this.username(model.username);
            this.hostKeys(model.hostKeys);
        }

        public final String getCertKey() {
            return this.certKey;
        }

        public final void setCertKey(String certKey) {
            this.certKey = certKey;
        }

        @Override
        public final Builder certKey(String certKey) {
            this.certKey = certKey;
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final Collection<String> getIpv6Addresses() {
            if (this.ipv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipv6Addresses;
        }

        public final void setIpv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(String ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final PasswordData.Builder getPasswordData() {
            return this.passwordData != null ? this.passwordData.toBuilder() : null;
        }

        public final void setPasswordData(PasswordData.BuilderImpl passwordData) {
            this.passwordData = passwordData != null ? passwordData.build() : null;
        }

        @Override
        public final Builder passwordData(PasswordData passwordData) {
            this.passwordData = passwordData;
            return this;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(InstanceAccessProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final List<HostKeyAttributes.Builder> getHostKeys() {
            List<HostKeyAttributes.Builder> result = HostKeysListCopier.copyToBuilder(this.hostKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHostKeys(Collection<HostKeyAttributes.BuilderImpl> hostKeys) {
            this.hostKeys = HostKeysListCopier.copyFromBuilder(hostKeys);
        }

        @Override
        public final Builder hostKeys(Collection<HostKeyAttributes> hostKeys) {
            this.hostKeys = HostKeysListCopier.copy(hostKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostKeys(HostKeyAttributes ... hostKeys) {
            this.hostKeys(Arrays.asList(hostKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostKeys(Consumer<HostKeyAttributes.Builder> ... hostKeys) {
            this.hostKeys(Stream.of(hostKeys).map(c -> (HostKeyAttributes)((HostKeyAttributes.Builder)HostKeyAttributes.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InstanceAccessDetails build() {
            return new InstanceAccessDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceAccessDetails> {
        public Builder certKey(String var1);

        public Builder expiresAt(Instant var1);

        public Builder ipAddress(String var1);

        public Builder ipv6Addresses(Collection<String> var1);

        public Builder ipv6Addresses(String ... var1);

        public Builder password(String var1);

        public Builder passwordData(PasswordData var1);

        default public Builder passwordData(Consumer<PasswordData.Builder> passwordData) {
            return this.passwordData((PasswordData)((PasswordData.Builder)PasswordData.builder().applyMutation(passwordData)).build());
        }

        public Builder privateKey(String var1);

        public Builder protocol(String var1);

        public Builder protocol(InstanceAccessProtocol var1);

        public Builder instanceName(String var1);

        public Builder username(String var1);

        public Builder hostKeys(Collection<HostKeyAttributes> var1);

        public Builder hostKeys(HostKeyAttributes ... var1);

        public Builder hostKeys(Consumer<HostKeyAttributes.Builder> ... var1);
    }
}

