/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.BehaviorEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CacheBehaviorPerPath
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CacheBehaviorPerPath> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(CacheBehaviorPerPath.getter(CacheBehaviorPerPath::path)).setter(CacheBehaviorPerPath.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<String> BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("behavior").getter(CacheBehaviorPerPath.getter(CacheBehaviorPerPath::behaviorAsString)).setter(CacheBehaviorPerPath.setter(Builder::behavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, BEHAVIOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CacheBehaviorPerPath.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String path;
    private final String behavior;

    private CacheBehaviorPerPath(BuilderImpl builder) {
        this.path = builder.path;
        this.behavior = builder.behavior;
    }

    public final String path() {
        return this.path;
    }

    public final BehaviorEnum behavior() {
        return BehaviorEnum.fromValue(this.behavior);
    }

    public final String behaviorAsString() {
        return this.behavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheBehaviorPerPath)) {
            return false;
        }
        CacheBehaviorPerPath other = (CacheBehaviorPerPath)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.behaviorAsString(), other.behaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CacheBehaviorPerPath").add("Path", (Object)this.path()).add("Behavior", (Object)this.behaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "behavior": {
                return Optional.ofNullable(clazz.cast(this.behaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("path", PATH_FIELD);
        map.put("behavior", BEHAVIOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CacheBehaviorPerPath, T> g) {
        return obj -> g.apply((CacheBehaviorPerPath)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String behavior;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheBehaviorPerPath model) {
            this.path(model.path);
            this.behavior(model.behavior);
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getBehavior() {
            return this.behavior;
        }

        public final void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @Override
        public final Builder behavior(String behavior) {
            this.behavior = behavior;
            return this;
        }

        @Override
        public final Builder behavior(BehaviorEnum behavior) {
            this.behavior(behavior == null ? null : behavior.toString());
            return this;
        }

        public CacheBehaviorPerPath build() {
            return new CacheBehaviorPerPath(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CacheBehaviorPerPath> {
        public Builder path(String var1);

        public Builder behavior(String var1);

        public Builder behavior(BehaviorEnum var1);
    }
}

