/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.ResourceNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachInstancesToLoadBalancerRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, AttachInstancesToLoadBalancerRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("loadBalancerName").getter(AttachInstancesToLoadBalancerRequest.getter(AttachInstancesToLoadBalancerRequest::loadBalancerName)).setter(AttachInstancesToLoadBalancerRequest.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerName").build()}).build();
    private static final SdkField<List<String>> INSTANCE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceNames").getter(AttachInstancesToLoadBalancerRequest.getter(AttachInstancesToLoadBalancerRequest::instanceNames)).setter(AttachInstancesToLoadBalancerRequest.setter(Builder::instanceNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD, INSTANCE_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AttachInstancesToLoadBalancerRequest.memberNameToFieldInitializer();
    private final String loadBalancerName;
    private final List<String> instanceNames;

    private AttachInstancesToLoadBalancerRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.instanceNames = builder.instanceNames;
    }

    public final String loadBalancerName() {
        return this.loadBalancerName;
    }

    public final boolean hasInstanceNames() {
        return this.instanceNames != null && !(this.instanceNames instanceof SdkAutoConstructList);
    }

    public final List<String> instanceNames() {
        return this.instanceNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceNames() ? this.instanceNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachInstancesToLoadBalancerRequest)) {
            return false;
        }
        AttachInstancesToLoadBalancerRequest other = (AttachInstancesToLoadBalancerRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && this.hasInstanceNames() == other.hasInstanceNames() && Objects.equals(this.instanceNames(), other.instanceNames());
    }

    public final String toString() {
        return ToString.builder((String)"AttachInstancesToLoadBalancerRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("InstanceNames", this.hasInstanceNames() ? this.instanceNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "loadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "instanceNames": {
                return Optional.ofNullable(clazz.cast(this.instanceNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("loadBalancerName", LOAD_BALANCER_NAME_FIELD);
        map.put("instanceNames", INSTANCE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttachInstancesToLoadBalancerRequest, T> g) {
        return obj -> g.apply((AttachInstancesToLoadBalancerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private List<String> instanceNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttachInstancesToLoadBalancerRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.instanceNames(model.instanceNames);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final Collection<String> getInstanceNames() {
            if (this.instanceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceNames;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = ResourceNameListCopier.copy(instanceNames);
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = ResourceNameListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String ... instanceNames) {
            this.instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachInstancesToLoadBalancerRequest build() {
            return new AttachInstancesToLoadBalancerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AttachInstancesToLoadBalancerRequest> {
        public Builder loadBalancerName(String var1);

        public Builder instanceNames(Collection<String> var1);

        public Builder instanceNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

