/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancerTlsPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoadBalancerTlsPolicy> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(LoadBalancerTlsPolicy.getter(LoadBalancerTlsPolicy::name)).setter(LoadBalancerTlsPolicy.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isDefault").getter(LoadBalancerTlsPolicy.getter(LoadBalancerTlsPolicy::isDefault)).setter(LoadBalancerTlsPolicy.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDefault").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(LoadBalancerTlsPolicy.getter(LoadBalancerTlsPolicy::description)).setter(LoadBalancerTlsPolicy.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("protocols").getter(LoadBalancerTlsPolicy.getter(LoadBalancerTlsPolicy::protocols)).setter(LoadBalancerTlsPolicy.setter(Builder::protocols)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CIPHERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ciphers").getter(LoadBalancerTlsPolicy.getter(LoadBalancerTlsPolicy::ciphers)).setter(LoadBalancerTlsPolicy.setter(Builder::ciphers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ciphers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IS_DEFAULT_FIELD, DESCRIPTION_FIELD, PROTOCOLS_FIELD, CIPHERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LoadBalancerTlsPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Boolean isDefault;
    private final String description;
    private final List<String> protocols;
    private final List<String> ciphers;

    private LoadBalancerTlsPolicy(BuilderImpl builder) {
        this.name = builder.name;
        this.isDefault = builder.isDefault;
        this.description = builder.description;
        this.protocols = builder.protocols;
        this.ciphers = builder.ciphers;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<String> protocols() {
        return this.protocols;
    }

    public final boolean hasCiphers() {
        return this.ciphers != null && !(this.ciphers instanceof SdkAutoConstructList);
    }

    public final List<String> ciphers() {
        return this.ciphers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocols() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCiphers() ? this.ciphers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTlsPolicy)) {
            return false;
        }
        LoadBalancerTlsPolicy other = (LoadBalancerTlsPolicy)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.isDefault(), other.isDefault()) && Objects.equals(this.description(), other.description()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocols(), other.protocols()) && this.hasCiphers() == other.hasCiphers() && Objects.equals(this.ciphers(), other.ciphers());
    }

    public final String toString() {
        return ToString.builder((String)"LoadBalancerTlsPolicy").add("Name", (Object)this.name()).add("IsDefault", (Object)this.isDefault()).add("Description", (Object)this.description()).add("Protocols", this.hasProtocols() ? this.protocols() : null).add("Ciphers", this.hasCiphers() ? this.ciphers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "isDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "protocols": {
                return Optional.ofNullable(clazz.cast(this.protocols()));
            }
            case "ciphers": {
                return Optional.ofNullable(clazz.cast(this.ciphers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("isDefault", IS_DEFAULT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("protocols", PROTOCOLS_FIELD);
        map.put("ciphers", CIPHERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerTlsPolicy, T> g) {
        return obj -> g.apply((LoadBalancerTlsPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Boolean isDefault;
        private String description;
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();
        private List<String> ciphers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTlsPolicy model) {
            this.name(model.name);
            this.isDefault(model.isDefault);
            this.description(model.description);
            this.protocols(model.protocols);
            this.ciphers(model.ciphers);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = StringListCopier.copy(protocols);
        }

        @Override
        public final Builder protocols(Collection<String> protocols) {
            this.protocols = StringListCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(String ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public final Collection<String> getCiphers() {
            if (this.ciphers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ciphers;
        }

        public final void setCiphers(Collection<String> ciphers) {
            this.ciphers = StringListCopier.copy(ciphers);
        }

        @Override
        public final Builder ciphers(Collection<String> ciphers) {
            this.ciphers = StringListCopier.copy(ciphers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ciphers(String ... ciphers) {
            this.ciphers(Arrays.asList(ciphers));
            return this;
        }

        public LoadBalancerTlsPolicy build() {
            return new LoadBalancerTlsPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoadBalancerTlsPolicy> {
        public Builder name(String var1);

        public Builder isDefault(Boolean var1);

        public Builder description(String var1);

        public Builder protocols(Collection<String> var1);

        public Builder protocols(String ... var1);

        public Builder ciphers(Collection<String> var1);

        public Builder ciphers(String ... var1);
    }
}

