/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.DiskInfo;
import software.amazon.awssdk.services.lightsail.model.DiskInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceSnapshotInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceSnapshotInfo> {
    private static final SdkField<String> FROM_BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fromBundleId").getter(InstanceSnapshotInfo.getter(InstanceSnapshotInfo::fromBundleId)).setter(InstanceSnapshotInfo.setter(Builder::fromBundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromBundleId").build()}).build();
    private static final SdkField<String> FROM_BLUEPRINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fromBlueprintId").getter(InstanceSnapshotInfo.getter(InstanceSnapshotInfo::fromBlueprintId)).setter(InstanceSnapshotInfo.setter(Builder::fromBlueprintId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromBlueprintId").build()}).build();
    private static final SdkField<List<DiskInfo>> FROM_DISK_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fromDiskInfo").getter(InstanceSnapshotInfo.getter(InstanceSnapshotInfo::fromDiskInfo)).setter(InstanceSnapshotInfo.setter(Builder::fromDiskInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromDiskInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DiskInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_BUNDLE_ID_FIELD, FROM_BLUEPRINT_ID_FIELD, FROM_DISK_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceSnapshotInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fromBundleId;
    private final String fromBlueprintId;
    private final List<DiskInfo> fromDiskInfo;

    private InstanceSnapshotInfo(BuilderImpl builder) {
        this.fromBundleId = builder.fromBundleId;
        this.fromBlueprintId = builder.fromBlueprintId;
        this.fromDiskInfo = builder.fromDiskInfo;
    }

    public final String fromBundleId() {
        return this.fromBundleId;
    }

    public final String fromBlueprintId() {
        return this.fromBlueprintId;
    }

    public final boolean hasFromDiskInfo() {
        return this.fromDiskInfo != null && !(this.fromDiskInfo instanceof SdkAutoConstructList);
    }

    public final List<DiskInfo> fromDiskInfo() {
        return this.fromDiskInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fromBundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFromDiskInfo() ? this.fromDiskInfo() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSnapshotInfo)) {
            return false;
        }
        InstanceSnapshotInfo other = (InstanceSnapshotInfo)obj;
        return Objects.equals(this.fromBundleId(), other.fromBundleId()) && Objects.equals(this.fromBlueprintId(), other.fromBlueprintId()) && this.hasFromDiskInfo() == other.hasFromDiskInfo() && Objects.equals(this.fromDiskInfo(), other.fromDiskInfo());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceSnapshotInfo").add("FromBundleId", (Object)this.fromBundleId()).add("FromBlueprintId", (Object)this.fromBlueprintId()).add("FromDiskInfo", this.hasFromDiskInfo() ? this.fromDiskInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fromBundleId": {
                return Optional.ofNullable(clazz.cast(this.fromBundleId()));
            }
            case "fromBlueprintId": {
                return Optional.ofNullable(clazz.cast(this.fromBlueprintId()));
            }
            case "fromDiskInfo": {
                return Optional.ofNullable(clazz.cast(this.fromDiskInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fromBundleId", FROM_BUNDLE_ID_FIELD);
        map.put("fromBlueprintId", FROM_BLUEPRINT_ID_FIELD);
        map.put("fromDiskInfo", FROM_DISK_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceSnapshotInfo, T> g) {
        return obj -> g.apply((InstanceSnapshotInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fromBundleId;
        private String fromBlueprintId;
        private List<DiskInfo> fromDiskInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSnapshotInfo model) {
            this.fromBundleId(model.fromBundleId);
            this.fromBlueprintId(model.fromBlueprintId);
            this.fromDiskInfo(model.fromDiskInfo);
        }

        public final String getFromBundleId() {
            return this.fromBundleId;
        }

        public final void setFromBundleId(String fromBundleId) {
            this.fromBundleId = fromBundleId;
        }

        @Override
        public final Builder fromBundleId(String fromBundleId) {
            this.fromBundleId = fromBundleId;
            return this;
        }

        public final String getFromBlueprintId() {
            return this.fromBlueprintId;
        }

        public final void setFromBlueprintId(String fromBlueprintId) {
            this.fromBlueprintId = fromBlueprintId;
        }

        @Override
        public final Builder fromBlueprintId(String fromBlueprintId) {
            this.fromBlueprintId = fromBlueprintId;
            return this;
        }

        public final List<DiskInfo.Builder> getFromDiskInfo() {
            List<DiskInfo.Builder> result = DiskInfoListCopier.copyToBuilder(this.fromDiskInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFromDiskInfo(Collection<DiskInfo.BuilderImpl> fromDiskInfo) {
            this.fromDiskInfo = DiskInfoListCopier.copyFromBuilder(fromDiskInfo);
        }

        @Override
        public final Builder fromDiskInfo(Collection<DiskInfo> fromDiskInfo) {
            this.fromDiskInfo = DiskInfoListCopier.copy(fromDiskInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromDiskInfo(DiskInfo ... fromDiskInfo) {
            this.fromDiskInfo(Arrays.asList(fromDiskInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromDiskInfo(Consumer<DiskInfo.Builder> ... fromDiskInfo) {
            this.fromDiskInfo(Stream.of(fromDiskInfo).map(c -> (DiskInfo)((DiskInfo.Builder)DiskInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InstanceSnapshotInfo build() {
            return new InstanceSnapshotInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceSnapshotInfo> {
        public Builder fromBundleId(String var1);

        public Builder fromBlueprintId(String var1);

        public Builder fromDiskInfo(Collection<DiskInfo> var1);

        public Builder fromDiskInfo(DiskInfo ... var1);

        public Builder fromDiskInfo(Consumer<DiskInfo.Builder> ... var1);
    }
}

