/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDiskSnapshotRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateDiskSnapshotRequest> {
    private static final SdkField<String> DISK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("diskName").getter(CreateDiskSnapshotRequest.getter(CreateDiskSnapshotRequest::diskName)).setter(CreateDiskSnapshotRequest.setter(Builder::diskName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskName").build()}).build();
    private static final SdkField<String> DISK_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("diskSnapshotName").getter(CreateDiskSnapshotRequest.getter(CreateDiskSnapshotRequest::diskSnapshotName)).setter(CreateDiskSnapshotRequest.setter(Builder::diskSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSnapshotName").build()}).build();
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceName").getter(CreateDiskSnapshotRequest.getter(CreateDiskSnapshotRequest::instanceName)).setter(CreateDiskSnapshotRequest.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateDiskSnapshotRequest.getter(CreateDiskSnapshotRequest::tags)).setter(CreateDiskSnapshotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_NAME_FIELD, DISK_SNAPSHOT_NAME_FIELD, INSTANCE_NAME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDiskSnapshotRequest.memberNameToFieldInitializer();
    private final String diskName;
    private final String diskSnapshotName;
    private final String instanceName;
    private final List<Tag> tags;

    private CreateDiskSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.diskName = builder.diskName;
        this.diskSnapshotName = builder.diskSnapshotName;
        this.instanceName = builder.instanceName;
        this.tags = builder.tags;
    }

    public final String diskName() {
        return this.diskName;
    }

    public final String diskSnapshotName() {
        return this.diskSnapshotName;
    }

    public final String instanceName() {
        return this.instanceName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.diskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDiskSnapshotRequest)) {
            return false;
        }
        CreateDiskSnapshotRequest other = (CreateDiskSnapshotRequest)((Object)obj);
        return Objects.equals(this.diskName(), other.diskName()) && Objects.equals(this.diskSnapshotName(), other.diskSnapshotName()) && Objects.equals(this.instanceName(), other.instanceName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDiskSnapshotRequest").add("DiskName", (Object)this.diskName()).add("DiskSnapshotName", (Object)this.diskSnapshotName()).add("InstanceName", (Object)this.instanceName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "diskName": {
                return Optional.ofNullable(clazz.cast(this.diskName()));
            }
            case "diskSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.diskSnapshotName()));
            }
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("diskName", DISK_NAME_FIELD);
        map.put("diskSnapshotName", DISK_SNAPSHOT_NAME_FIELD);
        map.put("instanceName", INSTANCE_NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDiskSnapshotRequest, T> g) {
        return obj -> g.apply((CreateDiskSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String diskName;
        private String diskSnapshotName;
        private String instanceName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDiskSnapshotRequest model) {
            super(model);
            this.diskName(model.diskName);
            this.diskSnapshotName(model.diskSnapshotName);
            this.instanceName(model.instanceName);
            this.tags(model.tags);
        }

        public final String getDiskName() {
            return this.diskName;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        @Override
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final String getDiskSnapshotName() {
            return this.diskSnapshotName;
        }

        public final void setDiskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
        }

        @Override
        public final Builder diskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
            return this;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDiskSnapshotRequest build() {
            return new CreateDiskSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDiskSnapshotRequest> {
        public Builder diskName(String var1);

        public Builder diskSnapshotName(String var1);

        public Builder instanceName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

