/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.BucketMetricName;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.MetricStatistic;
import software.amazon.awssdk.services.lightsail.model.MetricStatisticListCopier;
import software.amazon.awssdk.services.lightsail.model.MetricUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBucketMetricDataRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetBucketMetricDataRequest> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(GetBucketMetricDataRequest.getter(GetBucketMetricDataRequest::bucketName)).setter(GetBucketMetricDataRequest.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(GetBucketMetricDataRequest.getter(GetBucketMetricDataRequest::metricNameAsString)).setter(GetBucketMetricDataRequest.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetBucketMetricDataRequest.getter(GetBucketMetricDataRequest::startTime)).setter(GetBucketMetricDataRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetBucketMetricDataRequest.getter(GetBucketMetricDataRequest::endTime)).setter(GetBucketMetricDataRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("period").getter(GetBucketMetricDataRequest.getter(GetBucketMetricDataRequest::period)).setter(GetBucketMetricDataRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final SdkField<List<String>> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statistics").getter(GetBucketMetricDataRequest.getter(GetBucketMetricDataRequest::statisticsAsStrings)).setter(GetBucketMetricDataRequest.setter(Builder::statisticsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(GetBucketMetricDataRequest.getter(GetBucketMetricDataRequest::unitAsString)).setter(GetBucketMetricDataRequest.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, METRIC_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, PERIOD_FIELD, STATISTICS_FIELD, UNIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBucketMetricDataRequest.memberNameToFieldInitializer();
    private final String bucketName;
    private final String metricName;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer period;
    private final List<String> statistics;
    private final String unit;

    private GetBucketMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.bucketName = builder.bucketName;
        this.metricName = builder.metricName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.period = builder.period;
        this.statistics = builder.statistics;
        this.unit = builder.unit;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final BucketMetricName metricName() {
        return BucketMetricName.fromValue(this.metricName);
    }

    public final String metricNameAsString() {
        return this.metricName;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer period() {
        return this.period;
    }

    public final List<MetricStatistic> statistics() {
        return MetricStatisticListCopier.copyStringToEnum(this.statistics);
    }

    public final boolean hasStatistics() {
        return this.statistics != null && !(this.statistics instanceof SdkAutoConstructList);
    }

    public final List<String> statisticsAsStrings() {
        return this.statistics;
    }

    public final MetricUnit unit() {
        return MetricUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatistics() ? this.statisticsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketMetricDataRequest)) {
            return false;
        }
        GetBucketMetricDataRequest other = (GetBucketMetricDataRequest)((Object)obj);
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.period(), other.period()) && this.hasStatistics() == other.hasStatistics() && Objects.equals(this.statisticsAsStrings(), other.statisticsAsStrings()) && Objects.equals(this.unitAsString(), other.unitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetBucketMetricDataRequest").add("BucketName", (Object)this.bucketName()).add("MetricName", (Object)this.metricNameAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Period", (Object)this.period()).add("Statistics", this.hasStatistics() ? this.statisticsAsStrings() : null).add("Unit", (Object)this.unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricNameAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statisticsAsStrings()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bucketName", BUCKET_NAME_FIELD);
        map.put("metricName", METRIC_NAME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("period", PERIOD_FIELD);
        map.put("statistics", STATISTICS_FIELD);
        map.put("unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBucketMetricDataRequest, T> g) {
        return obj -> g.apply((GetBucketMetricDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String bucketName;
        private String metricName;
        private Instant startTime;
        private Instant endTime;
        private Integer period;
        private List<String> statistics = DefaultSdkAutoConstructList.getInstance();
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketMetricDataRequest model) {
            super(model);
            this.bucketName(model.bucketName);
            this.metricName(model.metricName);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.period(model.period);
            this.statisticsWithStrings(model.statistics);
            this.unit(model.unit);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(BucketMetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final Collection<String> getStatistics() {
            if (this.statistics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statistics;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
        }

        @Override
        public final Builder statisticsWithStrings(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsWithStrings(String ... statistics) {
            this.statisticsWithStrings(Arrays.asList(statistics));
            return this;
        }

        @Override
        public final Builder statistics(Collection<MetricStatistic> statistics) {
            this.statistics = MetricStatisticListCopier.copyEnumToString(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(MetricStatistic ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBucketMetricDataRequest build() {
            return new GetBucketMetricDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBucketMetricDataRequest> {
        public Builder bucketName(String var1);

        public Builder metricName(String var1);

        public Builder metricName(BucketMetricName var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder period(Integer var1);

        public Builder statisticsWithStrings(Collection<String> var1);

        public Builder statisticsWithStrings(String ... var1);

        public Builder statistics(Collection<MetricStatistic> var1);

        public Builder statistics(MetricStatistic ... var1);

        public Builder unit(String var1);

        public Builder unit(MetricUnit var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

