/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.Disk;

final class DiskListCopier {
    DiskListCopier() {
    }

    static List<Disk> copy(Collection<? extends Disk> diskListParam) {
        Object list;
        if (diskListParam == null || diskListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(diskListParam.size());
            diskListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Disk> copyFromBuilder(Collection<? extends Disk.Builder> diskListParam) {
        Object list;
        if (diskListParam == null || diskListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(diskListParam.size());
            diskListParam.forEach(entry -> {
                Disk member = entry == null ? null : (Disk)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Disk.Builder> copyToBuilder(Collection<? extends Disk> diskListParam) {
        Object list;
        if (diskListParam == null || diskListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(diskListParam.size());
            diskListParam.forEach(entry -> {
                Disk.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

