/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.BehaviorEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CacheBehavior
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CacheBehavior> {
    private static final SdkField<String> BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("behavior").getter(CacheBehavior.getter(CacheBehavior::behaviorAsString)).setter(CacheBehavior.setter(Builder::behavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEHAVIOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CacheBehavior.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String behavior;

    private CacheBehavior(BuilderImpl builder) {
        this.behavior = builder.behavior;
    }

    public final BehaviorEnum behavior() {
        return BehaviorEnum.fromValue(this.behavior);
    }

    public final String behaviorAsString() {
        return this.behavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheBehavior)) {
            return false;
        }
        CacheBehavior other = (CacheBehavior)obj;
        return Objects.equals(this.behaviorAsString(), other.behaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CacheBehavior").add("Behavior", (Object)this.behaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "behavior": {
                return Optional.ofNullable(clazz.cast(this.behaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("behavior", BEHAVIOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CacheBehavior, T> g) {
        return obj -> g.apply((CacheBehavior)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String behavior;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheBehavior model) {
            this.behavior(model.behavior);
        }

        public final String getBehavior() {
            return this.behavior;
        }

        public final void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @Override
        public final Builder behavior(String behavior) {
            this.behavior = behavior;
            return this;
        }

        @Override
        public final Builder behavior(BehaviorEnum behavior) {
            this.behavior(behavior == null ? null : behavior.toString());
            return this;
        }

        public CacheBehavior build() {
            return new CacheBehavior(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CacheBehavior> {
        public Builder behavior(String var1);

        public Builder behavior(BehaviorEnum var1);
    }
}

