/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoMountStatus {
    FAILED("Failed"),
    PENDING("Pending"),
    MOUNTED("Mounted"),
    NOT_MOUNTED("NotMounted"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoMountStatus> VALUE_MAP;
    private final String value;

    private AutoMountStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoMountStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoMountStatus> knownValues() {
        EnumSet<AutoMountStatus> knownValues = EnumSet.allOf(AutoMountStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoMountStatus.class, AutoMountStatus::toString);
    }
}

