/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.Disk;
import software.amazon.awssdk.services.lightsail.model.DiskListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceHardware
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceHardware> {
    private static final SdkField<Integer> CPU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(InstanceHardware.getter(InstanceHardware::cpuCount)).setter(InstanceHardware.setter(Builder::cpuCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCount").build()}).build();
    private static final SdkField<List<Disk>> DISKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceHardware.getter(InstanceHardware::disks)).setter(InstanceHardware.setter(Builder::disks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Disk::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> RAM_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(InstanceHardware.getter(InstanceHardware::ramSizeInGb)).setter(InstanceHardware.setter(Builder::ramSizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ramSizeInGb").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_COUNT_FIELD, DISKS_FIELD, RAM_SIZE_IN_GB_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer cpuCount;
    private final List<Disk> disks;
    private final Float ramSizeInGb;

    private InstanceHardware(BuilderImpl builder) {
        this.cpuCount = builder.cpuCount;
        this.disks = builder.disks;
        this.ramSizeInGb = builder.ramSizeInGb;
    }

    public Integer cpuCount() {
        return this.cpuCount;
    }

    public List<Disk> disks() {
        return this.disks;
    }

    public Float ramSizeInGb() {
        return this.ramSizeInGb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.disks());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramSizeInGb());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceHardware)) {
            return false;
        }
        InstanceHardware other = (InstanceHardware)obj;
        return Objects.equals(this.cpuCount(), other.cpuCount()) && Objects.equals(this.disks(), other.disks()) && Objects.equals(this.ramSizeInGb(), other.ramSizeInGb());
    }

    public String toString() {
        return ToString.builder((String)"InstanceHardware").add("CpuCount", (Object)this.cpuCount()).add("Disks", this.disks()).add("RamSizeInGb", (Object)this.ramSizeInGb()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cpuCount": {
                return Optional.ofNullable(clazz.cast(this.cpuCount()));
            }
            case "disks": {
                return Optional.ofNullable(clazz.cast(this.disks()));
            }
            case "ramSizeInGb": {
                return Optional.ofNullable(clazz.cast(this.ramSizeInGb()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceHardware, T> g) {
        return obj -> g.apply((InstanceHardware)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer cpuCount;
        private List<Disk> disks = DefaultSdkAutoConstructList.getInstance();
        private Float ramSizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceHardware model) {
            this.cpuCount(model.cpuCount);
            this.disks(model.disks);
            this.ramSizeInGb(model.ramSizeInGb);
        }

        public final Integer getCpuCount() {
            return this.cpuCount;
        }

        @Override
        public final Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final void setCpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
        }

        public final Collection<Disk.Builder> getDisks() {
            return this.disks != null ? (Collection)this.disks.stream().map(Disk::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder disks(Collection<Disk> disks) {
            this.disks = DiskListCopier.copy(disks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(Disk ... disks) {
            this.disks(Arrays.asList(disks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(Consumer<Disk.Builder> ... disks) {
            this.disks(Stream.of(disks).map(c -> (Disk)((Disk.Builder)Disk.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDisks(Collection<Disk.BuilderImpl> disks) {
            this.disks = DiskListCopier.copyFromBuilder(disks);
        }

        public final Float getRamSizeInGb() {
            return this.ramSizeInGb;
        }

        @Override
        public final Builder ramSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
            return this;
        }

        public final void setRamSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
        }

        public InstanceHardware build() {
            return new InstanceHardware(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceHardware> {
        public Builder cpuCount(Integer var1);

        public Builder disks(Collection<Disk> var1);

        public Builder disks(Disk ... var1);

        public Builder disks(Consumer<Disk.Builder> ... var1);

        public Builder ramSizeInGb(Float var1);
    }
}

