/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.ResourceBudgetEstimate;
import software.amazon.awssdk.services.lightsail.model.ResourcesBudgetEstimateCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCostEstimateResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetCostEstimateResponse> {
    private static final SdkField<List<ResourceBudgetEstimate>> RESOURCES_BUDGET_ESTIMATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourcesBudgetEstimate").getter(GetCostEstimateResponse.getter(GetCostEstimateResponse::resourcesBudgetEstimate)).setter(GetCostEstimateResponse.setter(Builder::resourcesBudgetEstimate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesBudgetEstimate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceBudgetEstimate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCES_BUDGET_ESTIMATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourcesBudgetEstimate", RESOURCES_BUDGET_ESTIMATE_FIELD);
        }
    });
    private final List<ResourceBudgetEstimate> resourcesBudgetEstimate;

    private GetCostEstimateResponse(BuilderImpl builder) {
        super(builder);
        this.resourcesBudgetEstimate = builder.resourcesBudgetEstimate;
    }

    public final boolean hasResourcesBudgetEstimate() {
        return this.resourcesBudgetEstimate != null && !(this.resourcesBudgetEstimate instanceof SdkAutoConstructList);
    }

    public final List<ResourceBudgetEstimate> resourcesBudgetEstimate() {
        return this.resourcesBudgetEstimate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourcesBudgetEstimate() ? this.resourcesBudgetEstimate() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostEstimateResponse)) {
            return false;
        }
        GetCostEstimateResponse other = (GetCostEstimateResponse)((Object)obj);
        return this.hasResourcesBudgetEstimate() == other.hasResourcesBudgetEstimate() && Objects.equals(this.resourcesBudgetEstimate(), other.resourcesBudgetEstimate());
    }

    public final String toString() {
        return ToString.builder((String)"GetCostEstimateResponse").add("ResourcesBudgetEstimate", this.hasResourcesBudgetEstimate() ? this.resourcesBudgetEstimate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourcesBudgetEstimate": {
                return Optional.ofNullable(clazz.cast(this.resourcesBudgetEstimate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCostEstimateResponse, T> g) {
        return obj -> g.apply((GetCostEstimateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<ResourceBudgetEstimate> resourcesBudgetEstimate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostEstimateResponse model) {
            super(model);
            this.resourcesBudgetEstimate(model.resourcesBudgetEstimate);
        }

        public final List<ResourceBudgetEstimate.Builder> getResourcesBudgetEstimate() {
            List<ResourceBudgetEstimate.Builder> result = ResourcesBudgetEstimateCopier.copyToBuilder(this.resourcesBudgetEstimate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourcesBudgetEstimate(Collection<ResourceBudgetEstimate.BuilderImpl> resourcesBudgetEstimate) {
            this.resourcesBudgetEstimate = ResourcesBudgetEstimateCopier.copyFromBuilder(resourcesBudgetEstimate);
        }

        @Override
        public final Builder resourcesBudgetEstimate(Collection<ResourceBudgetEstimate> resourcesBudgetEstimate) {
            this.resourcesBudgetEstimate = ResourcesBudgetEstimateCopier.copy(resourcesBudgetEstimate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesBudgetEstimate(ResourceBudgetEstimate ... resourcesBudgetEstimate) {
            this.resourcesBudgetEstimate(Arrays.asList(resourcesBudgetEstimate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesBudgetEstimate(Consumer<ResourceBudgetEstimate.Builder> ... resourcesBudgetEstimate) {
            this.resourcesBudgetEstimate(Stream.of(resourcesBudgetEstimate).map(c -> (ResourceBudgetEstimate)((ResourceBudgetEstimate.Builder)ResourceBudgetEstimate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetCostEstimateResponse build() {
            return new GetCostEstimateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCostEstimateResponse> {
        public Builder resourcesBudgetEstimate(Collection<ResourceBudgetEstimate> var1);

        public Builder resourcesBudgetEstimate(ResourceBudgetEstimate ... var1);

        public Builder resourcesBudgetEstimate(Consumer<ResourceBudgetEstimate.Builder> ... var1);
    }
}

