/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBucketsRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetBucketsRequest> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(GetBucketsRequest.getter(GetBucketsRequest::bucketName)).setter(GetBucketsRequest.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pageToken").getter(GetBucketsRequest.getter(GetBucketsRequest::pageToken)).setter(GetBucketsRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageToken").build()}).build();
    private static final SdkField<Boolean> INCLUDE_CONNECTED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeConnectedResources").getter(GetBucketsRequest.getter(GetBucketsRequest::includeConnectedResources)).setter(GetBucketsRequest.setter(Builder::includeConnectedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeConnectedResources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, PAGE_TOKEN_FIELD, INCLUDE_CONNECTED_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("bucketName", BUCKET_NAME_FIELD);
            this.put("pageToken", PAGE_TOKEN_FIELD);
            this.put("includeConnectedResources", INCLUDE_CONNECTED_RESOURCES_FIELD);
        }
    });
    private final String bucketName;
    private final String pageToken;
    private final Boolean includeConnectedResources;

    private GetBucketsRequest(BuilderImpl builder) {
        super(builder);
        this.bucketName = builder.bucketName;
        this.pageToken = builder.pageToken;
        this.includeConnectedResources = builder.includeConnectedResources;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String pageToken() {
        return this.pageToken;
    }

    public final Boolean includeConnectedResources() {
        return this.includeConnectedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeConnectedResources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketsRequest)) {
            return false;
        }
        GetBucketsRequest other = (GetBucketsRequest)((Object)obj);
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.pageToken(), other.pageToken()) && Objects.equals(this.includeConnectedResources(), other.includeConnectedResources());
    }

    public final String toString() {
        return ToString.builder((String)"GetBucketsRequest").add("BucketName", (Object)this.bucketName()).add("PageToken", (Object)this.pageToken()).add("IncludeConnectedResources", (Object)this.includeConnectedResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "pageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
            case "includeConnectedResources": {
                return Optional.ofNullable(clazz.cast(this.includeConnectedResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketsRequest, T> g) {
        return obj -> g.apply((GetBucketsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String bucketName;
        private String pageToken;
        private Boolean includeConnectedResources;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketsRequest model) {
            super(model);
            this.bucketName(model.bucketName);
            this.pageToken(model.pageToken);
            this.includeConnectedResources(model.includeConnectedResources);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final Boolean getIncludeConnectedResources() {
            return this.includeConnectedResources;
        }

        public final void setIncludeConnectedResources(Boolean includeConnectedResources) {
            this.includeConnectedResources = includeConnectedResources;
        }

        @Override
        public final Builder includeConnectedResources(Boolean includeConnectedResources) {
            this.includeConnectedResources = includeConnectedResources;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBucketsRequest build() {
            return new GetBucketsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBucketsRequest> {
        public Builder bucketName(String var1);

        public Builder pageToken(String var1);

        public Builder includeConnectedResources(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

