/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprintListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRelationalDatabaseBlueprintsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetRelationalDatabaseBlueprintsResponse> {
    private static final SdkField<List<RelationalDatabaseBlueprint>> BLUEPRINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blueprints").getter(GetRelationalDatabaseBlueprintsResponse.getter(GetRelationalDatabaseBlueprintsResponse::blueprints)).setter(GetRelationalDatabaseBlueprintsResponse.setter(Builder::blueprints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelationalDatabaseBlueprint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetRelationalDatabaseBlueprintsResponse.getter(GetRelationalDatabaseBlueprintsResponse::nextPageToken)).setter(GetRelationalDatabaseBlueprintsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINTS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("blueprints", BLUEPRINTS_FIELD);
            this.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        }
    });
    private final List<RelationalDatabaseBlueprint> blueprints;
    private final String nextPageToken;

    private GetRelationalDatabaseBlueprintsResponse(BuilderImpl builder) {
        super(builder);
        this.blueprints = builder.blueprints;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasBlueprints() {
        return this.blueprints != null && !(this.blueprints instanceof SdkAutoConstructList);
    }

    public final List<RelationalDatabaseBlueprint> blueprints() {
        return this.blueprints;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlueprints() ? this.blueprints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseBlueprintsResponse)) {
            return false;
        }
        GetRelationalDatabaseBlueprintsResponse other = (GetRelationalDatabaseBlueprintsResponse)((Object)obj);
        return this.hasBlueprints() == other.hasBlueprints() && Objects.equals(this.blueprints(), other.blueprints()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetRelationalDatabaseBlueprintsResponse").add("Blueprints", this.hasBlueprints() ? this.blueprints() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blueprints": {
                return Optional.ofNullable(clazz.cast(this.blueprints()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseBlueprintsResponse, T> g) {
        return obj -> g.apply((GetRelationalDatabaseBlueprintsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<RelationalDatabaseBlueprint> blueprints = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseBlueprintsResponse model) {
            super(model);
            this.blueprints(model.blueprints);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<RelationalDatabaseBlueprint.Builder> getBlueprints() {
            List<RelationalDatabaseBlueprint.Builder> result = RelationalDatabaseBlueprintListCopier.copyToBuilder(this.blueprints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlueprints(Collection<RelationalDatabaseBlueprint.BuilderImpl> blueprints) {
            this.blueprints = RelationalDatabaseBlueprintListCopier.copyFromBuilder(blueprints);
        }

        @Override
        public final Builder blueprints(Collection<RelationalDatabaseBlueprint> blueprints) {
            this.blueprints = RelationalDatabaseBlueprintListCopier.copy(blueprints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(RelationalDatabaseBlueprint ... blueprints) {
            this.blueprints(Arrays.asList(blueprints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Consumer<RelationalDatabaseBlueprint.Builder> ... blueprints) {
            this.blueprints(Stream.of(blueprints).map(c -> (RelationalDatabaseBlueprint)((RelationalDatabaseBlueprint.Builder)RelationalDatabaseBlueprint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetRelationalDatabaseBlueprintsResponse build() {
            return new GetRelationalDatabaseBlueprintsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRelationalDatabaseBlueprintsResponse> {
        public Builder blueprints(Collection<RelationalDatabaseBlueprint> var1);

        public Builder blueprints(RelationalDatabaseBlueprint ... var1);

        public Builder blueprints(Consumer<RelationalDatabaseBlueprint.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

