/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus;
import software.amazon.awssdk.services.lightsail.model.BPAStatusMessage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountLevelBpaSync
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountLevelBpaSync> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AccountLevelBpaSync.getter(AccountLevelBpaSync::statusAsString)).setter(AccountLevelBpaSync.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_SYNCED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastSyncedAt").getter(AccountLevelBpaSync.getter(AccountLevelBpaSync::lastSyncedAt)).setter(AccountLevelBpaSync.setter(Builder::lastSyncedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSyncedAt").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(AccountLevelBpaSync.getter(AccountLevelBpaSync::messageAsString)).setter(AccountLevelBpaSync.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Boolean> BPA_IMPACTS_LIGHTSAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("bpaImpactsLightsail").getter(AccountLevelBpaSync.getter(AccountLevelBpaSync::bpaImpactsLightsail)).setter(AccountLevelBpaSync.setter(Builder::bpaImpactsLightsail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bpaImpactsLightsail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, LAST_SYNCED_AT_FIELD, MESSAGE_FIELD, BPA_IMPACTS_LIGHTSAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("status", STATUS_FIELD);
            this.put("lastSyncedAt", LAST_SYNCED_AT_FIELD);
            this.put("message", MESSAGE_FIELD);
            this.put("bpaImpactsLightsail", BPA_IMPACTS_LIGHTSAIL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Instant lastSyncedAt;
    private final String message;
    private final Boolean bpaImpactsLightsail;

    private AccountLevelBpaSync(BuilderImpl builder) {
        this.status = builder.status;
        this.lastSyncedAt = builder.lastSyncedAt;
        this.message = builder.message;
        this.bpaImpactsLightsail = builder.bpaImpactsLightsail;
    }

    public final AccountLevelBpaSyncStatus status() {
        return AccountLevelBpaSyncStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastSyncedAt() {
        return this.lastSyncedAt;
    }

    public final BPAStatusMessage message() {
        return BPAStatusMessage.fromValue(this.message);
    }

    public final String messageAsString() {
        return this.message;
    }

    public final Boolean bpaImpactsLightsail() {
        return this.bpaImpactsLightsail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSyncedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bpaImpactsLightsail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountLevelBpaSync)) {
            return false;
        }
        AccountLevelBpaSync other = (AccountLevelBpaSync)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastSyncedAt(), other.lastSyncedAt()) && Objects.equals(this.messageAsString(), other.messageAsString()) && Objects.equals(this.bpaImpactsLightsail(), other.bpaImpactsLightsail());
    }

    public final String toString() {
        return ToString.builder((String)"AccountLevelBpaSync").add("Status", (Object)this.statusAsString()).add("LastSyncedAt", (Object)this.lastSyncedAt()).add("Message", (Object)this.messageAsString()).add("BpaImpactsLightsail", (Object)this.bpaImpactsLightsail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastSyncedAt": {
                return Optional.ofNullable(clazz.cast(this.lastSyncedAt()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.messageAsString()));
            }
            case "bpaImpactsLightsail": {
                return Optional.ofNullable(clazz.cast(this.bpaImpactsLightsail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccountLevelBpaSync, T> g) {
        return obj -> g.apply((AccountLevelBpaSync)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Instant lastSyncedAt;
        private String message;
        private Boolean bpaImpactsLightsail;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountLevelBpaSync model) {
            this.status(model.status);
            this.lastSyncedAt(model.lastSyncedAt);
            this.message(model.message);
            this.bpaImpactsLightsail(model.bpaImpactsLightsail);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AccountLevelBpaSyncStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastSyncedAt() {
            return this.lastSyncedAt;
        }

        public final void setLastSyncedAt(Instant lastSyncedAt) {
            this.lastSyncedAt = lastSyncedAt;
        }

        @Override
        public final Builder lastSyncedAt(Instant lastSyncedAt) {
            this.lastSyncedAt = lastSyncedAt;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public final Builder message(BPAStatusMessage message) {
            this.message(message == null ? null : message.toString());
            return this;
        }

        public final Boolean getBpaImpactsLightsail() {
            return this.bpaImpactsLightsail;
        }

        public final void setBpaImpactsLightsail(Boolean bpaImpactsLightsail) {
            this.bpaImpactsLightsail = bpaImpactsLightsail;
        }

        @Override
        public final Builder bpaImpactsLightsail(Boolean bpaImpactsLightsail) {
            this.bpaImpactsLightsail = bpaImpactsLightsail;
            return this;
        }

        public AccountLevelBpaSync build() {
            return new AccountLevelBpaSync(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountLevelBpaSync> {
        public Builder status(String var1);

        public Builder status(AccountLevelBpaSyncStatus var1);

        public Builder lastSyncedAt(Instant var1);

        public Builder message(String var1);

        public Builder message(BPAStatusMessage var1);

        public Builder bpaImpactsLightsail(Boolean var1);
    }
}

