/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AddOnRequest;
import software.amazon.awssdk.services.lightsail.model.AddOnRequestListCopier;
import software.amazon.awssdk.services.lightsail.model.IpAddressType;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInstancesRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateInstancesRequest> {
    private static final SdkField<List<String>> INSTANCE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceNames").getter(CreateInstancesRequest.getter(CreateInstancesRequest::instanceNames)).setter(CreateInstancesRequest.setter(Builder::instanceNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(CreateInstancesRequest.getter(CreateInstancesRequest::availabilityZone)).setter(CreateInstancesRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> CUSTOM_IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customImageName").getter(CreateInstancesRequest.getter(CreateInstancesRequest::customImageName)).setter(CreateInstancesRequest.setter(Builder::customImageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customImageName").build()}).build();
    private static final SdkField<String> BLUEPRINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintId").getter(CreateInstancesRequest.getter(CreateInstancesRequest::blueprintId)).setter(CreateInstancesRequest.setter(Builder::blueprintId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintId").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bundleId").getter(CreateInstancesRequest.getter(CreateInstancesRequest::bundleId)).setter(CreateInstancesRequest.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()}).build();
    private static final SdkField<String> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userData").getter(CreateInstancesRequest.getter(CreateInstancesRequest::userData)).setter(CreateInstancesRequest.setter(Builder::userData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userData").build()}).build();
    private static final SdkField<String> KEY_PAIR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyPairName").getter(CreateInstancesRequest.getter(CreateInstancesRequest::keyPairName)).setter(CreateInstancesRequest.setter(Builder::keyPairName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPairName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateInstancesRequest.getter(CreateInstancesRequest::tags)).setter(CreateInstancesRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AddOnRequest>> ADD_ONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addOns").getter(CreateInstancesRequest.getter(CreateInstancesRequest::addOns)).setter(CreateInstancesRequest.setter(Builder::addOns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddOnRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddressType").getter(CreateInstancesRequest.getter(CreateInstancesRequest::ipAddressTypeAsString)).setter(CreateInstancesRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAMES_FIELD, AVAILABILITY_ZONE_FIELD, CUSTOM_IMAGE_NAME_FIELD, BLUEPRINT_ID_FIELD, BUNDLE_ID_FIELD, USER_DATA_FIELD, KEY_PAIR_NAME_FIELD, TAGS_FIELD, ADD_ONS_FIELD, IP_ADDRESS_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("instanceNames", INSTANCE_NAMES_FIELD);
            this.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
            this.put("customImageName", CUSTOM_IMAGE_NAME_FIELD);
            this.put("blueprintId", BLUEPRINT_ID_FIELD);
            this.put("bundleId", BUNDLE_ID_FIELD);
            this.put("userData", USER_DATA_FIELD);
            this.put("keyPairName", KEY_PAIR_NAME_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("addOns", ADD_ONS_FIELD);
            this.put("ipAddressType", IP_ADDRESS_TYPE_FIELD);
        }
    });
    private final List<String> instanceNames;
    private final String availabilityZone;
    private final String customImageName;
    private final String blueprintId;
    private final String bundleId;
    private final String userData;
    private final String keyPairName;
    private final List<Tag> tags;
    private final List<AddOnRequest> addOns;
    private final String ipAddressType;

    private CreateInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceNames = builder.instanceNames;
        this.availabilityZone = builder.availabilityZone;
        this.customImageName = builder.customImageName;
        this.blueprintId = builder.blueprintId;
        this.bundleId = builder.bundleId;
        this.userData = builder.userData;
        this.keyPairName = builder.keyPairName;
        this.tags = builder.tags;
        this.addOns = builder.addOns;
        this.ipAddressType = builder.ipAddressType;
    }

    public final boolean hasInstanceNames() {
        return this.instanceNames != null && !(this.instanceNames instanceof SdkAutoConstructList);
    }

    public final List<String> instanceNames() {
        return this.instanceNames;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    @Deprecated
    public final String customImageName() {
        return this.customImageName;
    }

    public final String blueprintId() {
        return this.blueprintId;
    }

    public final String bundleId() {
        return this.bundleId;
    }

    public final String userData() {
        return this.userData;
    }

    public final String keyPairName() {
        return this.keyPairName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasAddOns() {
        return this.addOns != null && !(this.addOns instanceof SdkAutoConstructList);
    }

    public final List<AddOnRequest> addOns() {
        return this.addOns;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceNames() ? this.instanceNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.customImageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddOns() ? this.addOns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesRequest)) {
            return false;
        }
        CreateInstancesRequest other = (CreateInstancesRequest)((Object)obj);
        return this.hasInstanceNames() == other.hasInstanceNames() && Objects.equals(this.instanceNames(), other.instanceNames()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.customImageName(), other.customImageName()) && Objects.equals(this.blueprintId(), other.blueprintId()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.keyPairName(), other.keyPairName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasAddOns() == other.hasAddOns() && Objects.equals(this.addOns(), other.addOns()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInstancesRequest").add("InstanceNames", this.hasInstanceNames() ? this.instanceNames() : null).add("AvailabilityZone", (Object)this.availabilityZone()).add("CustomImageName", (Object)this.customImageName()).add("BlueprintId", (Object)this.blueprintId()).add("BundleId", (Object)this.bundleId()).add("UserData", (Object)this.userData()).add("KeyPairName", (Object)this.keyPairName()).add("Tags", this.hasTags() ? this.tags() : null).add("AddOns", this.hasAddOns() ? this.addOns() : null).add("IpAddressType", (Object)this.ipAddressTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceNames": {
                return Optional.ofNullable(clazz.cast(this.instanceNames()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "customImageName": {
                return Optional.ofNullable(clazz.cast(this.customImageName()));
            }
            case "blueprintId": {
                return Optional.ofNullable(clazz.cast(this.blueprintId()));
            }
            case "bundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "userData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "keyPairName": {
                return Optional.ofNullable(clazz.cast(this.keyPairName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "addOns": {
                return Optional.ofNullable(clazz.cast(this.addOns()));
            }
            case "ipAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateInstancesRequest, T> g) {
        return obj -> g.apply((CreateInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private List<String> instanceNames = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZone;
        private String customImageName;
        private String blueprintId;
        private String bundleId;
        private String userData;
        private String keyPairName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<AddOnRequest> addOns = DefaultSdkAutoConstructList.getInstance();
        private String ipAddressType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstancesRequest model) {
            super(model);
            this.instanceNames(model.instanceNames);
            this.availabilityZone(model.availabilityZone);
            this.customImageName(model.customImageName);
            this.blueprintId(model.blueprintId);
            this.bundleId(model.bundleId);
            this.userData(model.userData);
            this.keyPairName(model.keyPairName);
            this.tags(model.tags);
            this.addOns(model.addOns);
            this.ipAddressType(model.ipAddressType);
        }

        public final Collection<String> getInstanceNames() {
            if (this.instanceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceNames;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String ... instanceNames) {
            this.instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        @Deprecated
        public final String getCustomImageName() {
            return this.customImageName;
        }

        @Deprecated
        public final void setCustomImageName(String customImageName) {
            this.customImageName = customImageName;
        }

        @Override
        @Deprecated
        public final Builder customImageName(String customImageName) {
            this.customImageName = customImageName;
            return this;
        }

        public final String getBlueprintId() {
            return this.blueprintId;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getUserData() {
            return this.userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final String getKeyPairName() {
            return this.keyPairName;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AddOnRequest.Builder> getAddOns() {
            List<AddOnRequest.Builder> result = AddOnRequestListCopier.copyToBuilder(this.addOns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOns(Collection<AddOnRequest.BuilderImpl> addOns) {
            this.addOns = AddOnRequestListCopier.copyFromBuilder(addOns);
        }

        @Override
        public final Builder addOns(Collection<AddOnRequest> addOns) {
            this.addOns = AddOnRequestListCopier.copy(addOns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(AddOnRequest ... addOns) {
            this.addOns(Arrays.asList(addOns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(Consumer<AddOnRequest.Builder> ... addOns) {
            this.addOns(Stream.of(addOns).map(c -> (AddOnRequest)((AddOnRequest.Builder)AddOnRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstancesRequest build() {
            return new CreateInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInstancesRequest> {
        public Builder instanceNames(Collection<String> var1);

        public Builder instanceNames(String ... var1);

        public Builder availabilityZone(String var1);

        @Deprecated
        public Builder customImageName(String var1);

        public Builder blueprintId(String var1);

        public Builder bundleId(String var1);

        public Builder userData(String var1);

        public Builder keyPairName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder addOns(Collection<AddOnRequest> var1);

        public Builder addOns(AddOnRequest ... var1);

        public Builder addOns(Consumer<AddOnRequest.Builder> ... var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

