/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.EstimateByTime;
import software.amazon.awssdk.services.lightsail.model.EstimatesByTimeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CostEstimate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CostEstimate> {
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageType").getter(CostEstimate.getter(CostEstimate::usageType)).setter(CostEstimate.setter(Builder::usageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()}).build();
    private static final SdkField<List<EstimateByTime>> RESULTS_BY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resultsByTime").getter(CostEstimate.getter(CostEstimate::resultsByTime)).setter(CostEstimate.setter(Builder::resultsByTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultsByTime").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EstimateByTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_TYPE_FIELD, RESULTS_BY_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("usageType", USAGE_TYPE_FIELD);
            this.put("resultsByTime", RESULTS_BY_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String usageType;
    private final List<EstimateByTime> resultsByTime;

    private CostEstimate(BuilderImpl builder) {
        this.usageType = builder.usageType;
        this.resultsByTime = builder.resultsByTime;
    }

    public final String usageType() {
        return this.usageType;
    }

    public final boolean hasResultsByTime() {
        return this.resultsByTime != null && !(this.resultsByTime instanceof SdkAutoConstructList);
    }

    public final List<EstimateByTime> resultsByTime() {
        return this.resultsByTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.usageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultsByTime() ? this.resultsByTime() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostEstimate)) {
            return false;
        }
        CostEstimate other = (CostEstimate)obj;
        return Objects.equals(this.usageType(), other.usageType()) && this.hasResultsByTime() == other.hasResultsByTime() && Objects.equals(this.resultsByTime(), other.resultsByTime());
    }

    public final String toString() {
        return ToString.builder((String)"CostEstimate").add("UsageType", (Object)this.usageType()).add("ResultsByTime", this.hasResultsByTime() ? this.resultsByTime() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "usageType": {
                return Optional.ofNullable(clazz.cast(this.usageType()));
            }
            case "resultsByTime": {
                return Optional.ofNullable(clazz.cast(this.resultsByTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CostEstimate, T> g) {
        return obj -> g.apply((CostEstimate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String usageType;
        private List<EstimateByTime> resultsByTime = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CostEstimate model) {
            this.usageType(model.usageType);
            this.resultsByTime(model.resultsByTime);
        }

        public final String getUsageType() {
            return this.usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final List<EstimateByTime.Builder> getResultsByTime() {
            List<EstimateByTime.Builder> result = EstimatesByTimeCopier.copyToBuilder(this.resultsByTime);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultsByTime(Collection<EstimateByTime.BuilderImpl> resultsByTime) {
            this.resultsByTime = EstimatesByTimeCopier.copyFromBuilder(resultsByTime);
        }

        @Override
        public final Builder resultsByTime(Collection<EstimateByTime> resultsByTime) {
            this.resultsByTime = EstimatesByTimeCopier.copy(resultsByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsByTime(EstimateByTime ... resultsByTime) {
            this.resultsByTime(Arrays.asList(resultsByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsByTime(Consumer<EstimateByTime.Builder> ... resultsByTime) {
            this.resultsByTime(Stream.of(resultsByTime).map(c -> (EstimateByTime)((EstimateByTime.Builder)EstimateByTime.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CostEstimate build() {
            return new CostEstimate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CostEstimate> {
        public Builder usageType(String var1);

        public Builder resultsByTime(Collection<EstimateByTime> var1);

        public Builder resultsByTime(EstimateByTime ... var1);

        public Builder resultsByTime(Consumer<EstimateByTime.Builder> ... var1);
    }
}

