/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelationalDatabaseBlueprint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelationalDatabaseBlueprint> {
    private static final SdkField<String> BLUEPRINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintId").getter(RelationalDatabaseBlueprint.getter(RelationalDatabaseBlueprint::blueprintId)).setter(RelationalDatabaseBlueprint.setter(Builder::blueprintId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintId").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engine").getter(RelationalDatabaseBlueprint.getter(RelationalDatabaseBlueprint::engineAsString)).setter(RelationalDatabaseBlueprint.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engineVersion").getter(RelationalDatabaseBlueprint.getter(RelationalDatabaseBlueprint::engineVersion)).setter(RelationalDatabaseBlueprint.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()}).build();
    private static final SdkField<String> ENGINE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engineDescription").getter(RelationalDatabaseBlueprint.getter(RelationalDatabaseBlueprint::engineDescription)).setter(RelationalDatabaseBlueprint.setter(Builder::engineDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineDescription").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engineVersionDescription").getter(RelationalDatabaseBlueprint.getter(RelationalDatabaseBlueprint::engineVersionDescription)).setter(RelationalDatabaseBlueprint.setter(Builder::engineVersionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersionDescription").build()}).build();
    private static final SdkField<Boolean> IS_ENGINE_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isEngineDefault").getter(RelationalDatabaseBlueprint.getter(RelationalDatabaseBlueprint::isEngineDefault)).setter(RelationalDatabaseBlueprint.setter(Builder::isEngineDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isEngineDefault").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ID_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, ENGINE_DESCRIPTION_FIELD, ENGINE_VERSION_DESCRIPTION_FIELD, IS_ENGINE_DEFAULT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String blueprintId;
    private final String engine;
    private final String engineVersion;
    private final String engineDescription;
    private final String engineVersionDescription;
    private final Boolean isEngineDefault;

    private RelationalDatabaseBlueprint(BuilderImpl builder) {
        this.blueprintId = builder.blueprintId;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.engineDescription = builder.engineDescription;
        this.engineVersionDescription = builder.engineVersionDescription;
        this.isEngineDefault = builder.isEngineDefault;
    }

    public final String blueprintId() {
        return this.blueprintId;
    }

    public final RelationalDatabaseEngine engine() {
        return RelationalDatabaseEngine.fromValue(this.engine);
    }

    public final String engineAsString() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String engineDescription() {
        return this.engineDescription;
    }

    public final String engineVersionDescription() {
        return this.engineVersionDescription;
    }

    public final Boolean isEngineDefault() {
        return this.isEngineDefault;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.isEngineDefault());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabaseBlueprint)) {
            return false;
        }
        RelationalDatabaseBlueprint other = (RelationalDatabaseBlueprint)obj;
        return Objects.equals(this.blueprintId(), other.blueprintId()) && Objects.equals(this.engineAsString(), other.engineAsString()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.engineDescription(), other.engineDescription()) && Objects.equals(this.engineVersionDescription(), other.engineVersionDescription()) && Objects.equals(this.isEngineDefault(), other.isEngineDefault());
    }

    public final String toString() {
        return ToString.builder((String)"RelationalDatabaseBlueprint").add("BlueprintId", (Object)this.blueprintId()).add("Engine", (Object)this.engineAsString()).add("EngineVersion", (Object)this.engineVersion()).add("EngineDescription", (Object)this.engineDescription()).add("EngineVersionDescription", (Object)this.engineVersionDescription()).add("IsEngineDefault", (Object)this.isEngineDefault()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blueprintId": {
                return Optional.ofNullable(clazz.cast(this.blueprintId()));
            }
            case "engine": {
                return Optional.ofNullable(clazz.cast(this.engineAsString()));
            }
            case "engineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "engineDescription": {
                return Optional.ofNullable(clazz.cast(this.engineDescription()));
            }
            case "engineVersionDescription": {
                return Optional.ofNullable(clazz.cast(this.engineVersionDescription()));
            }
            case "isEngineDefault": {
                return Optional.ofNullable(clazz.cast(this.isEngineDefault()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabaseBlueprint, T> g) {
        return obj -> g.apply((RelationalDatabaseBlueprint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String blueprintId;
        private String engine;
        private String engineVersion;
        private String engineDescription;
        private String engineVersionDescription;
        private Boolean isEngineDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabaseBlueprint model) {
            this.blueprintId(model.blueprintId);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.engineDescription(model.engineDescription);
            this.engineVersionDescription(model.engineVersionDescription);
            this.isEngineDefault(model.isEngineDefault);
        }

        public final String getBlueprintId() {
            return this.blueprintId;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(RelationalDatabaseEngine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getEngineDescription() {
            return this.engineDescription;
        }

        public final void setEngineDescription(String engineDescription) {
            this.engineDescription = engineDescription;
        }

        @Override
        public final Builder engineDescription(String engineDescription) {
            this.engineDescription = engineDescription;
            return this;
        }

        public final String getEngineVersionDescription() {
            return this.engineVersionDescription;
        }

        public final void setEngineVersionDescription(String engineVersionDescription) {
            this.engineVersionDescription = engineVersionDescription;
        }

        @Override
        public final Builder engineVersionDescription(String engineVersionDescription) {
            this.engineVersionDescription = engineVersionDescription;
            return this;
        }

        public final Boolean getIsEngineDefault() {
            return this.isEngineDefault;
        }

        public final void setIsEngineDefault(Boolean isEngineDefault) {
            this.isEngineDefault = isEngineDefault;
        }

        @Override
        public final Builder isEngineDefault(Boolean isEngineDefault) {
            this.isEngineDefault = isEngineDefault;
            return this;
        }

        public RelationalDatabaseBlueprint build() {
            return new RelationalDatabaseBlueprint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelationalDatabaseBlueprint> {
        public Builder blueprintId(String var1);

        public Builder engine(String var1);

        public Builder engine(RelationalDatabaseEngine var1);

        public Builder engineVersion(String var1);

        public Builder engineDescription(String var1);

        public Builder engineVersionDescription(String var1);

        public Builder isEngineDefault(Boolean var1);
    }
}

